/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.subscribe;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive_item.AbstractHandImmersive;
import com.hammy275.immersivemc.client.immersive_item.HandImmersives;
import com.hammy275.immersivemc.client.model.Cube1x1;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.util.RGBA;
import com.hammy275.immersivemc.common.util.ShieldUtil;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.time.Instant;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1839;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class ClientRenderSubscriber {
    public static final Cube1x1 cubeModel = new Cube1x1(class_310.method_1551().method_31974().method_32072(Cube1x1.LAYER_LOCATION));
    public static final List<ItemGuideRenderData> itemGuideRenderData = new ArrayList<ItemGuideRenderData>(128);
    private static long lastMillis;
    private static RGBA itemGuideColor;
    private static float cycleProgress;
    private static RGBA itemGuideSelectedColor;
    private static float cycleProgressSelected;
    private static RGBA rangedGrabColor;
    private static float cycleProgressRangedGrab;

    public static void onWorldRender(class_4587 stack) {
        ClientRenderSubscriber.setRenderColors();
        try {
            for (Immersive immersive : Immersives.IMMERSIVES) {
                ClientRenderSubscriber.renderInfos(immersive, stack);
            }
            for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
                ClientRenderSubscriber.renderInfos(abstractPlayerAttachmentImmersive, stack);
            }
            if (VRPluginVerify.clientInVR()) {
                for (AbstractHandImmersive abstractHandImmersive : HandImmersives.HAND_IMMERSIVES) {
                    abstractHandImmersive.renderAll(stack);
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        if (VRPluginVerify.clientInVR()) {
            for (class_1268 iHand : class_1268.values()) {
                if (class_310.method_1551().field_1724.method_5998(iHand).method_7976() != class_1839.field_8949) continue;
                IVRPlayer vrPlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724) : VRPlugin.API.getRenderVRPlayer();
                IVRData hand = vrPlayer.getController(iHand.ordinal());
                ImmersiveRenderHelpers.instance().renderHitbox(stack, ShieldUtil.getShieldHitbox((class_1657)class_310.method_1551().field_1724, hand, iHand), false, 1.0f, 1.0f, 1.0f);
            }
        }
        class_310.method_1551().method_22940().method_23000().method_22993();
        for (ItemGuideRenderData itemGuideRenderData : ClientRenderSubscriber.itemGuideRenderData) {
            ClientRenderSubscriber.renderItemGuide(itemGuideRenderData.stack, itemGuideRenderData.hitbox, itemGuideRenderData.alpha, itemGuideRenderData.isSelected, itemGuideRenderData.light);
        }
        class_310.method_1551().method_22940().method_23000().method_22993();
        itemGuideRenderData.clear();
    }

    public static void setRenderColors() {
        if (lastMillis == 0L) {
            lastMillis = Instant.now().toEpochMilli();
        }
        ItemGuideColorData colorData = ActiveConfig.FILE_CLIENT.itemGuidePreset.colorData.get();
        long now = Instant.now().toEpochMilli();
        long timeDiff = now - lastMillis;
        int transitionTimeMS = colorData.transitionTimeMS().get();
        if (colorData.colors().get().size() > 1) {
            cycleProgress = (cycleProgress + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.colors().get().size())) % 1.0f;
        }
        if (colorData.selectedColors().get().size() > 1) {
            cycleProgressSelected = (cycleProgressSelected + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.selectedColors().get().size())) % 1.0f;
        }
        if (colorData.rangedGrabColors().get().size() > 1) {
            cycleProgressRangedGrab = (cycleProgressRangedGrab + (float)timeDiff / (float)((long)transitionTimeMS * (long)colorData.rangedGrabColors().get().size())) % 1.0f;
        }
        itemGuideColor = ClientRenderSubscriber.updateColor(colorData.colors().get(), cycleProgress);
        itemGuideSelectedColor = ClientRenderSubscriber.updateColor(colorData.selectedColors().get(), cycleProgressSelected);
        rangedGrabColor = ClientRenderSubscriber.updateColor(colorData.rangedGrabColors().get(), cycleProgressRangedGrab);
        lastMillis = now;
    }

    public static void resetCycleProgresses() {
        cycleProgress = 0.0f;
        cycleProgressSelected = 0.0f;
        cycleProgressRangedGrab = 0.0f;
    }

    protected static <I extends ImmersiveInfo> void renderInfos(Immersive<I, ?> singleton, class_4587 stack) {
        try {
            if (singleton.isVROnly() && !VRPluginVerify.clientInVR()) {
                return;
            }
            for (ImmersiveInfo info : singleton.getTrackedObjects()) {
                if (!singleton.shouldRender(info)) continue;
                singleton.render(info, stack, ImmersiveRenderHelpers.instance(), class_310.method_1551().method_1488());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    protected static <I extends AbstractPlayerAttachmentInfo> void renderInfos(AbstractPlayerAttachmentImmersive<I, ?> singleton, class_4587 stack) {
        try {
            if (singleton.isVROnly() && !VRPluginVerify.clientInVR()) {
                return;
            }
            for (AbstractPlayerAttachmentInfo info : singleton.getTrackedObjects()) {
                singleton.doRender(info, stack, VRPluginVerify.clientInVR());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private static void renderItemGuide(class_4587 stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
        if (hitbox != null && !class_310.method_1551().field_1690.field_1842) {
            RGBA color = isSelected ? ClientRenderSubscriber.itemGuideSelectedColor() : ClientRenderSubscriber.itemGuideColor();
            class_238 aabb = hitbox.isAABB() ? hitbox.asAABB() : hitbox.asOBB().getUnderlyingAABB();
            float size = (float)aabb.method_995() * (isSelected ? (float)ActiveConfig.active().itemGuideSelectedSize : (float)ActiveConfig.active().itemGuideSize);
            if (ActiveConfig.active().placementGuideMode == PlacementGuideMode.CUBE) {
                class_4184 renderInfo = class_310.method_1551().field_1773.method_19418();
                class_243 pos = aabb.method_1005();
                stack.method_22903();
                stack.method_22904(-renderInfo.method_19326().field_1352 + pos.field_1352, -renderInfo.method_19326().field_1351 + pos.field_1351, -renderInfo.method_19326().field_1350 + pos.field_1350);
                class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
                if (hitbox.isOBB()) {
                    OBBClientUtil.rotateStackForOBB(stack, hitbox.asOBB());
                }
                cubeModel.render(stack, buffer.getBuffer(class_1921.method_23580((class_2960)Cube1x1.textureLocation)), color.redF(), color.greenF(), color.blueF(), color.alphaF(), size / 2.0f, light);
                stack.method_22909();
            } else if (ActiveConfig.active().placementGuideMode == PlacementGuideMode.OUTLINE) {
                if (hitbox.isAABB()) {
                    ImmersiveRenderHelpers.instance().renderHitbox(stack, (BoundingBox)class_238.method_30048((class_243)aabb.method_1005(), (double)size, (double)size, (double)size), true, color.redF(), color.greenF(), color.blueF(), color.alphaF());
                } else {
                    OBBClientUtil.renderOBB(stack, hitbox.asOBB(), true, color.redF(), color.greenF(), color.blueF(), color.alphaF());
                }
            }
        }
    }

    public static RGBA itemGuideColor() {
        return itemGuideColor;
    }

    public static RGBA itemGuideSelectedColor() {
        return itemGuideSelectedColor;
    }

    public static RGBA rangedGrabColor() {
        return rangedGrabColor;
    }

    private static RGBA updateColor(List<RGBA> colors, float cycleProgress) {
        if (colors.size() == 1) {
            return colors.get(0);
        }
        float progressPerColor = 1.0f / (float)colors.size();
        int startIndex = (int)(cycleProgress / progressPerColor);
        int endIndex = startIndex + 1;
        if (endIndex == colors.size()) {
            endIndex = 0;
        }
        RGBA start = colors.get(startIndex);
        RGBA end = colors.get(endIndex);
        float transitionProgress = cycleProgress % progressPerColor / progressPerColor;
        return new RGBA(ClientRenderSubscriber.avgColorTransition(start, end, 'r', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'g', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'b', transitionProgress), ClientRenderSubscriber.avgColorTransition(start, end, 'a', transitionProgress));
    }

    private static int avgColorTransition(RGBA start, RGBA end, char c, float transitionProgress) {
        return (int)((float)start.getColor(c) * (1.0f - transitionProgress) + (float)end.getColor(c) * transitionProgress);
    }

    public record ItemGuideRenderData(class_4587 stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
    }
}

