/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.immersive.MultiblockImmersiveHandler;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ChestLikeHandler;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ChestHandler
extends ChestLikeHandler
implements MultiblockImmersiveHandler<ListOfItemsStorage> {
    @Override
    public ListOfItemsStorage makeInventoryContents(class_3222 player, class_2338 pos) {
        class_2586 blockEntity = player.method_37908().method_8321(pos);
        if (blockEntity instanceof class_2595) {
            class_2595 cbe = (class_2595)blockEntity;
            ListOfItemsStorage storage = super.makeInventoryContents(player, pos);
            class_2595 otherChest = Util.getOtherChest(cbe);
            if (otherChest != null) {
                ListOfItemsStorage otherStorage = super.makeInventoryContents(player, otherChest.method_11016());
                storage.getItems().addAll(otherStorage.getItems());
            }
            return storage;
        }
        ArrayList<class_1799> items = new ArrayList<class_1799>(player.method_7274().method_5439());
        for (int i = 0; i < player.method_7274().method_5439(); ++i) {
            items.add(player.method_7274().method_5438(i));
        }
        return new ListOfItemsStorage(items, 27);
    }

    @Override
    public void swap(int slot, class_1268 hand, class_2338 pos, class_3222 player, ItemSwapAmount amount) {
        class_2586 blockEntity = player.method_37908().method_8321(pos);
        if (blockEntity instanceof class_2595) {
            class_2595 cbe = (class_2595)blockEntity;
            Swap.handleChest(cbe, player, hand, slot);
        } else if (blockEntity instanceof class_2611) {
            Swap.handleEnderChest((class_1657)player, hand, slot);
        }
    }

    @Override
    public boolean isDirtyForClientSync(class_3222 player, class_2338 pos) {
        class_2586 blockEntity = player.method_37908().method_8321(pos);
        if (blockEntity instanceof class_2611) {
            return player.field_6012 % 2 == 0;
        }
        boolean isDirtyForClientSync = super.isDirtyForClientSync(player, pos);
        class_2595 otherChest = Util.getOtherChest((class_2595)player.method_37908().method_8321(pos));
        if (otherChest != null) {
            isDirtyForClientSync = isDirtyForClientSync || super.isDirtyForClientSync(player, otherChest.method_11016());
        }
        return isDirtyForClientSync;
    }

    @Override
    public boolean isValidBlock(class_2338 pos, class_1937 level) {
        class_2586 blockEntity = level.method_8321(pos);
        return (blockEntity instanceof class_2595 || blockEntity instanceof class_2611) && super.isValidBlock(pos, level);
    }

    @Override
    public boolean enabledInConfig(class_1657 player) {
        return ActiveConfig.getActiveConfigCommon((class_1657)player).useChestImmersive;
    }

    @Override
    public class_2960 getID() {
        return new class_2960("immersivemc", "chest");
    }

    @Override
    @Nullable
    public Set<class_2338> getHandledBlocks(class_2338 pos, class_1937 level) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof class_2611) {
            return Set.of(pos);
        }
        if (be instanceof class_2595) {
            class_2595 cbe = (class_2595)be;
            class_2595 other = Util.getOtherChest(cbe);
            if (other != null) {
                return Set.of(pos, other.method_11016());
            }
            return Set.of(pos);
        }
        return null;
    }
}

