/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network;

import com.hammy275.immersivemc.ImmersiveMC;
import com.hammy275.immersivemc.Platform;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class NetworkChannel {
    private final List<NetworkRegistrationData<?>> packets = new ArrayList();

    public <T> void register(Class<T> clazz, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, class_3222> handler) {
        this.packets.add(new NetworkRegistrationData<T>(this.packets.size(), clazz, encoder, decoder, handler));
    }

    public <T> void sendToServer(T message) {
        Platform.sendToServer(this.encode(message));
    }

    public <T> void sendToPlayer(class_3222 player, T message) {
        Platform.sendToPlayer(player, this.encode(message));
    }

    public <T> void sendToPlayers(Iterable<class_3222> players, T message) {
        players.forEach(p -> this.sendToPlayer((class_3222)p, message));
    }

    public <T> void doReceive(@Nullable class_3222 player, class_2540 buffer) {
        Object message;
        NetworkRegistrationData<?> data = this.packets.get(buffer.readInt());
        try {
            message = data.decoder.apply(buffer);
        }
        catch (Exception e) {
            ImmersiveMC.LOGGER.log(Level.ERROR, "Error while decoding packet.", (Throwable)e);
            return;
        }
        data.handler.accept(message, player);
    }

    private <T> class_2540 encode(T message) {
        NetworkRegistrationData<T> data = this.getData(message);
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(data.id());
        data.encoder().accept(message, buffer);
        return buffer;
    }

    private <T> NetworkRegistrationData<T> getData(T message) {
        NetworkRegistrationData data = this.packets.stream().filter(d -> d.clazz == message.getClass()).findFirst().orElse(null);
        if (data == null) {
            throw new IllegalArgumentException("Packet type %s not registered!".formatted(message.getClass().getName()));
        }
        return data;
    }

    public record NetworkRegistrationData<T>(int id, Class<T> clazz, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, class_3222> handler) {
    }
}

