/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.immersive.storage.dual.impl.BeaconStorage;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3913;

public class BeaconConfirmPacket {
    public final class_2338 pos;
    public final int primaryId;
    public final int secondaryId;

    public BeaconConfirmPacket(class_2338 beaconPos, int primaryId, int secondaryId) {
        this.pos = beaconPos;
        this.primaryId = primaryId;
        this.secondaryId = secondaryId;
    }

    public static void encode(BeaconConfirmPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos).writeInt(packet.primaryId).writeInt(packet.secondaryId);
    }

    public static BeaconConfirmPacket decode(class_2540 buffer) {
        return new BeaconConfirmPacket(buffer.method_10811(), buffer.readInt(), buffer.readInt());
    }

    public static void handle(BeaconConfirmPacket message, class_3222 player) {
        class_2586 class_25862;
        if (NetworkUtil.safeToRun(message.pos, player) && (class_25862 = player.method_37908().method_8321(message.pos)) instanceof class_2580) {
            class_2580 beacon = (class_2580)class_25862;
            class_3913 data = ((BeaconBlockEntityMixin)beacon).immersiveMC$getBeaconData();
            BeaconStorage beaconStorage = (BeaconStorage)WorldStoragesImpl.getOrCreateS(message.pos, player.method_51469());
            int secondId = message.secondaryId;
            if (data.method_17390(0) == 4 && message.secondaryId == -1) {
                secondId = message.primaryId;
            }
            if (!beaconStorage.getItem(0).method_7960() && BeaconConfirmPacket.isValidForBeacon(data.method_17390(0), message.primaryId, secondId)) {
                beaconStorage.setItem(0, class_1799.field_8037);
                data.method_17391(1, message.primaryId);
                data.method_17391(2, secondId);
                beaconStorage.setDirty(player.method_51469());
                player.method_37908().method_8524(beacon.method_11016());
            }
        }
    }

    private static boolean isValidForBeacon(int beaconLevel, int primaryId, int secondaryId) {
        class_1291 secondary;
        if (beaconLevel < 1 || beaconLevel < 4 && secondaryId != -1) {
            return false;
        }
        class_1291 primary = primaryId == -1 ? null : class_1291.method_5569((int)primaryId);
        class_1291 class_12912 = secondary = secondaryId == -1 ? null : class_1291.method_5569((int)secondaryId);
        if (beaconLevel == 1) {
            return primary == class_1294.field_5904 || primary == class_1294.field_5917;
        }
        if (beaconLevel == 2) {
            return primary == class_1294.field_5907 || primary == class_1294.field_5913 || BeaconConfirmPacket.isValidForBeacon(1, primaryId, secondaryId);
        }
        if (beaconLevel == 3) {
            return primary == class_1294.field_5910 || BeaconConfirmPacket.isValidForBeacon(2, primaryId, secondaryId);
        }
        return (secondary == class_1294.field_5924 || BeaconConfirmPacket.isValidForBeacon(3, secondaryId, -1)) && BeaconConfirmPacket.isValidForBeacon(3, primaryId, -1);
    }
}

