/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class ChestToOpenSet {
    private static final Map<PosLevel, Set<UUID>> chestImmersiveOpenSet = new HashMap<PosLevel, Set<UUID>>();

    public static void openChest(class_1657 player, class_2338 pos) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(player.method_37908(), pos, true);
        set.add(player.method_5667());
    }

    public static void closeChest(class_1657 player, class_2338 pos) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(player.method_37908(), pos, false);
        if (set != null) {
            set.remove(player.method_5667());
            if (set.isEmpty()) {
                chestImmersiveOpenSet.remove(new PosLevel(pos, player.method_37908()));
            }
        }
    }

    public static int getOpenCount(class_2338 pos, class_1937 level) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(level, pos, false);
        return set != null ? set.size() : 0;
    }

    public static void clear() {
        chestImmersiveOpenSet.clear();
    }

    public static void clearForPlayer(class_1657 player) {
        ArrayList toRemove = new ArrayList();
        chestImmersiveOpenSet.forEach((posLevel, set) -> {
            set.remove(player.method_5667());
            if (set.isEmpty()) {
                toRemove.add(posLevel);
            }
        });
        toRemove.forEach(chestImmersiveOpenSet.keySet()::remove);
    }

    private static Set<UUID> getOpenSet(class_1937 level, class_2338 pos, boolean createIfNotPresent) {
        Set<UUID> set = chestImmersiveOpenSet.get(new PosLevel(pos, level));
        if (createIfNotPresent && set == null) {
            set = new HashSet<UUID>();
            chestImmersiveOpenSet.put(new PosLevel(pos, level), set);
        }
        return set;
    }

    private record PosLevel(class_2338 pos, class_1937 level) {
        public boolean matches(class_2338 otherPos, class_1937 otherLevel) {
            return this.pos.equals((Object)otherPos) && this.level == otherLevel;
        }
    }
}

