/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import com.hammy275.immersivemc.server.ServerVRSubscriber;
import com.hammy275.immersivemc.server.immersive.DirtyTracker;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCLevelStorage;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;

public class ServerSubscriber {
    public static MinecraftServer server;

    public static void onServerTick(MinecraftServer server) {
        ServerSubscriber.server = server;
        SharedNetworkStorages.instance().getAll(LecternData.class).forEach(data -> data.tick(null));
        for (AbstractTracker tracker : ServerTrackerInit.globalTrackers) {
            tracker.doTick(null);
        }
        TrackedImmersives.tick(server);
        DirtyTracker.unmarkAllDirty();
        ImmersiveMCLevelStorage.unmarkAllItemStoragesDirty(server);
        SharedNetworkStorages.instance().getAll(LecternData.class).forEach(data -> ((CommonBookData)data.bookData).setNoLongerDirty());
    }

    public static void onPlayerTick(class_1657 playerIn) {
        class_3965 blockHit;
        class_239 hit;
        if (playerIn.method_37908().field_9236) {
            return;
        }
        class_3222 player = (class_3222)playerIn;
        for (AbstractTracker tracker : ServerTrackerInit.playerTrackers) {
            tracker.doTick((class_1657)player);
        }
        if (VRPluginVerify.hasAPI) {
            ServerVRSubscriber.vrPlayerTick(player);
        }
        if ((hit = player.method_5745(15.0, 0.0f, false)) instanceof class_3965 && (blockHit = (class_3965)hit).method_17783() != class_239.class_240.field_1333) {
            TrackedImmersives.maybeTrackImmersive(player, blockHit.method_17777());
        }
    }

    public static void onPlayerJoin(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ActiveConfig config = ImmersiveMCPlayerStorages.isPlayerDisabled((class_1657)serverPlayer) ? ActiveConfig.DISABLED : ActiveConfig.FILE_SERVER;
            Network.INSTANCE.sendToPlayer(serverPlayer, new ConfigSyncPacket(config, ImmersiveHandlers.HANDLERS.stream().filter(handler -> !handler.clientAuthoritative()).map(ImmersiveHandler::getID).toList()));
        }
    }

    public static void onPlayerLeave(class_1657 playerIn) {
        if (playerIn instanceof class_3222) {
            class_3222 player = (class_3222)playerIn;
            TrackedImmersives.clearForPlayer(player);
            ChestToOpenSet.clearForPlayer((class_1657)player);
        }
    }
}

