/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.server.ServerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class ImmersiveMCPlayerStorages
extends class_18 {
    private static final int PLAYER_STORAGES_VERSION = 2;
    protected Map<UUID, List<class_1799>> backpackCraftingItemsMap = new HashMap<UUID, List<class_1799>>();
    protected Set<UUID> disabledPlayers = new HashSet<UUID>();

    private static ImmersiveMCPlayerStorages create() {
        return new ImmersiveMCPlayerStorages();
    }

    public static List<class_1799> getBackpackCraftingStorage(class_1657 player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((class_1657)player).backpackCraftingItemsMap.computeIfAbsent(player.method_5667(), uuid -> {
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (int i = 0; i <= 4; ++i) {
                items.add(class_1799.field_8037);
            }
            return items;
        });
    }

    public static ImmersiveMCPlayerStorages getPlayerStorage(class_1657 player) {
        if (!player.method_37908().field_9236) {
            class_3222 sPlayer = (class_3222)player;
            return (ImmersiveMCPlayerStorages)sPlayer.method_5682().method_30002().method_17983().method_17924(ImmersiveMCPlayerStorages::load, ImmersiveMCPlayerStorages::create, "immersivemc_player_data");
        }
        throw new IllegalArgumentException("Can only access storage on server-side!");
    }

    public static boolean isPlayerDisabled(class_1657 player) {
        return ImmersiveMCPlayerStorages.getPlayerStorage((class_1657)player).disabledPlayers.contains(player.method_5667());
    }

    public static void setPlayerDisabled(class_1657 player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.add(player.method_5667());
        storage.method_80();
    }

    public static void setPlayerEnabled(class_1657 player) {
        ImmersiveMCPlayerStorages storage = ImmersiveMCPlayerStorages.getPlayerStorage(player);
        storage.disabledPlayers.remove(player.method_5667());
        storage.method_80();
    }

    public static ImmersiveMCPlayerStorages load(class_2487 nbt) {
        class_2487 disabledPlayers;
        ImmersiveMCPlayerStorages playerStorage = new ImmersiveMCPlayerStorages();
        int lastVanillaDataVersion = nbt.method_10545("lastVanillaDataVersion") ? nbt.method_10550("lastVanillaDataVersion") : Math.min(3700, class_155.method_16673().method_37912().method_38494());
        nbt = ImmersiveMCPlayerStorages.maybeUpgradeNBT(nbt, lastVanillaDataVersion);
        Set keys = nbt.method_10541();
        for (String uuidStr : keys) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                class_2487 bagItems = nbt.method_10562(uuidStr).method_10562("bagItems");
                ArrayList<class_1799> items = new ArrayList<class_1799>();
                for (int i = 0; i <= 4; ++i) {
                    items.add(ServerUtil.parseItem(bagItems.method_10562(String.valueOf(i)), lastVanillaDataVersion));
                }
                playerStorage.backpackCraftingItemsMap.put(uuid, items);
            }
            catch (IllegalArgumentException uuid) {}
        }
        class_2487 class_24872 = disabledPlayers = nbt.method_10545("disabledPlayers") ? nbt.method_10562("disabledPlayers") : null;
        if (disabledPlayers != null) {
            for (String key : disabledPlayers.method_10541()) {
                if (!disabledPlayers.method_10558(key).equalsIgnoreCase("true")) continue;
                playerStorage.disabledPlayers.add(UUID.fromString(key));
            }
        }
        return playerStorage;
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10569("lastVanillaDataVersion", class_155.method_16673().method_37912().method_38494());
        nbt.method_10569("version", 2);
        for (Map.Entry<UUID, List<class_1799>> entry : this.backpackCraftingItemsMap.entrySet()) {
            class_2487 playerData = new class_2487();
            class_2487 bagData = new class_2487();
            List<class_1799> items = entry.getValue();
            for (int i = 0; i <= 4; ++i) {
                class_2487 itemData = new class_2487();
                itemData = i >= items.size() ? class_1799.field_8037.method_7953(itemData) : items.get(i).method_7953(itemData);
                bagData.method_10566(String.valueOf(i), (class_2520)itemData);
            }
            playerData.method_10566("bagItems", (class_2520)bagData);
            nbt.method_10566(String.valueOf(entry.getKey()), (class_2520)playerData);
        }
        class_2487 disabledPlayers = new class_2487();
        for (UUID disabled : this.disabledPlayers) {
            disabledPlayers.method_10582(disabled.toString(), "true");
        }
        nbt.method_10566("disabledPlayers", (class_2520)disabledPlayers);
        return nbt;
    }

    private static class_2487 maybeUpgradeNBT(class_2487 nbtIn, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.method_10545("version")) {
            version = nbtIn.method_10550("version");
        }
        while (version < 2) {
            if (version == 1) {
                class_2487 newNBT = new class_2487();
                Set keys = nbtIn.method_10541();
                for (String uuidStr : keys) {
                    class_2487 oldPlayerData = nbtIn.method_10562(uuidStr);
                    class_2487 bagItems = oldPlayerData.method_10562("storages").method_10562("0").method_10562("data");
                    bagItems.method_10551("identifier");
                    bagItems.method_10551("numOfItems");
                    for (int i = 0; i <= 4; ++i) {
                        class_2487 itemData = bagItems.method_10562("item" + i);
                        bagItems.method_10551("item" + i);
                        bagItems.method_10566(String.valueOf(i), (class_2520)itemData);
                    }
                    class_2487 newPlayerData = new class_2487();
                    newPlayerData.method_10566("bagItems", (class_2520)bagItems);
                    newNBT.method_10566(uuidStr, (class_2520)newPlayerData);
                }
                nbtIn = newNBT;
            }
            ++version;
        }
        return nbtIn;
    }
}

