/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.client.compat.ipn.IPN;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.BackpackInfo;
import com.hammy275.immersivemc.client.model.BackpackBundleModel;
import com.hammy275.immersivemc.client.model.BackpackCraftingModel;
import com.hammy275.immersivemc.client.model.BackpackLowDetailModel;
import com.hammy275.immersivemc.client.model.BackpackModel;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.FetchBackpackStoragePacket;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import org.jetbrains.annotations.Nullable;

public class ImmersiveBackpack
extends AbstractPlayerAttachmentImmersive<BackpackInfo, NullStorage> {
    public static final BackpackBundleModel bundleModel = new BackpackBundleModel(class_310.method_1551().method_31974().method_32072(BackpackBundleModel.LAYER_LOCATION));
    public static final BackpackModel model = new BackpackModel(class_310.method_1551().method_31974().method_32072(BackpackModel.LAYER_LOCATION));
    public static final BackpackLowDetailModel modelLowDetail = new BackpackLowDetailModel(class_310.method_1551().method_31974().method_32072(BackpackLowDetailModel.LAYER_LOCATION));
    public static final BackpackCraftingModel craftingModel = new BackpackCraftingModel(class_310.method_1551().method_31974().method_32072(BackpackCraftingModel.LAYER_LOCATION));
    private static final class_1160 maxColor = new class_1160(1.0f, 1.0f, 1.0f);
    private final double spacing = 0.375;

    public ImmersiveBackpack() {
        super(1);
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void renderTick(BackpackInfo info, boolean isInVR) {
        super.renderTick(info, isInVR);
        IVRPlayer vrPlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724) : VRPlugin.API.getRenderVRPlayer();
        this.calculatePositions(info, vrPlayer);
    }

    @Override
    protected void doTick(BackpackInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        info.light = this.getLight(this.getLightPos(info));
    }

    @Override
    @Nullable
    public ImmersiveHandler getHandler() {
        return null;
    }

    @Override
    public class_2338 getLightPos(BackpackInfo info) {
        class_2338 c1 = new class_2338(VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController(this.getBagControllerNum()).position());
        if (!class_310.method_1551().field_1687.method_8320(c1).method_26225()) {
            return c1;
        }
        return new class_2338(VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getHMD().position());
    }

    public static void onHitboxInteract(class_1657 player, BackpackInfo info, int slot) {
        if (slot <= 26) {
            class_1661 inventory = player.method_31548();
            if (IPN.ipnCompat.available() && !Util.stacksEqualBesidesCount(inventory.method_5438(slot + 9), inventory.method_5438(inventory.field_7545))) {
                IPN.ipnCompat.doInventorySwap(slot + 9, inventory.field_7545);
            } else {
                Network.INSTANCE.sendToServer(new SwapPacket(class_2338.field_10980, List.of(Integer.valueOf(slot + 9)), class_1268.field_5808, SwapMode.SINGLE, SwapPacket.SwapDestination.INVENTORY));
                Swap.handleInventorySwap(player, slot + 9, class_1268.field_5808);
            }
        } else {
            Network.INSTANCE.sendToServer(new SwapPacket(class_2338.field_10980, List.of(Integer.valueOf(slot)), class_1268.field_5808, SwapMode.SINGLE, SwapPacket.SwapDestination.BAG_CRAFTING));
            Network.INSTANCE.sendToServer(new FetchBackpackStoragePacket());
        }
    }

    protected boolean inRange(int num, int start, int end) {
        return start <= num && num <= end;
    }

    @Override
    public boolean shouldRender(BackpackInfo info, boolean isInVR) {
        return class_310.method_1551().field_1724 != null && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR((class_1657)class_310.method_1551().field_1724) && VRPlugin.API.apiActive((class_1657)class_310.method_1551().field_1724) && info.light >= 0;
    }

    @Override
    protected void render(BackpackInfo info, class_4587 stack, boolean isInVR) {
        float size;
        class_1799 item;
        int i;
        boolean leftHanded = this.leftHanded();
        for (i = 0; i <= 31; ++i) {
            this.renderHitbox(stack, info.getHitbox(i));
        }
        for (i = 0; i <= 26; ++i) {
            item = class_310.method_1551().field_1724.method_31548().method_5438(i + 9);
            if (item.method_7960() || info.getPosition(i) == null) continue;
            size = info.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, info.getPosition(i), size, null, info.getHitbox(i), true, info.light);
        }
        for (i = 27; i <= 31; ++i) {
            class_1799 class_17992 = item = i == 31 ? info.craftingOutput : info.craftingInput[i - 27];
            if (item.method_7960() || info.getPosition(i) == null) continue;
            size = info.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, info.getPosition(i), size, null, info.getHitbox(i), true, info.light);
        }
        stack.method_22903();
        class_243 pos = info.renderPos;
        class_4184 cameraInfo = class_310.method_1551().field_1773.method_19418();
        stack.method_22904(-cameraInfo.method_19326().field_1352 + pos.field_1352, -cameraInfo.method_19326().field_1351 + pos.field_1351, -cameraInfo.method_19326().field_1350 + pos.field_1350);
        stack.method_22905(0.5f, 0.5f, 0.5f);
        stack.method_22907(class_1160.field_20704.method_23626(info.handYaw));
        stack.method_22907(class_1160.field_20702.method_23626(info.handPitch));
        stack.method_22907(class_1160.field_20707.method_23626((float)Math.PI + info.handRoll));
        stack.method_22904(0.0, -3.0, 0.0);
        ImmersiveBackpack.getBackpackModel().method_2828(stack, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23576((class_2960)ImmersiveBackpack.getBackpackTexture())), info.light, class_4608.field_21444, info.rgb.method_4943(), info.rgb.method_4945(), info.rgb.method_4947(), 1.0f);
        stack.method_22904(leftHanded ? -0.75 : 0.75, 0.25, 0.0);
        craftingModel.method_2828(stack, class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23576((class_2960)BackpackCraftingModel.textureLocation)), info.light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.method_22909();
        if (ActiveConfig.active().placementGuideMode != PlacementGuideMode.OFF) {
            for (int i2 = 0; i2 < info.getInputSlots().length; ++i2) {
                if (!this.inputSlotShouldRenderHelpHitbox(info, i2)) continue;
                this.enqueueItemGuideRender(stack, info.getInputSlots()[i2], 0.2f, this.slotHelpBoxIsSelected(info, i2), info.light);
            }
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.active().useBagImmersive;
    }

    @Override
    protected boolean inputSlotShouldRenderHelpHitbox(BackpackInfo info, int slotNum) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        if (slotNum <= 26) {
            return class_310.method_1551().field_1724.method_31548().method_5438(slotNum + 9).method_7960();
        }
        int tableIndex = slotNum - 27;
        return info.craftingInput[tableIndex] == null || info.craftingInput[tableIndex].method_7960();
    }

    @Override
    public boolean shouldTrack(class_2338 pos, class_1937 level) {
        return true;
    }

    @Override
    public BackpackInfo refreshOrTrackObject(class_2338 pos, class_1937 level) {
        return null;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo info) {
        return false;
    }

    @Override
    protected void initInfo(BackpackInfo info) {
        Network.INSTANCE.sendToServer(new FetchBackpackStoragePacket());
    }

    @Override
    public void handleRightClick(AbstractPlayerAttachmentInfo info, class_1657 player, int closest, class_1268 hand) {
    }

    @Override
    public void processStorageFromNetwork(AbstractPlayerAttachmentInfo info, NullStorage storage) {
    }

    public void processFromNetwork(List<class_1799> items) {
        if (this.infos.size() > 0) {
            BackpackInfo info = (BackpackInfo)this.infos.get(0);
            for (int i = 0; i <= 3; ++i) {
                info.craftingInput[i] = items.get(i);
            }
            info.craftingOutput = items.get(4);
        }
    }

    public void doTrack() {
        if (this.infos.isEmpty()) {
            this.infos.add(new BackpackInfo());
        } else {
            this.infos.clear();
        }
    }

    public static class_3879 getBackpackModel() {
        switch (ActiveConfig.active().bagMode) {
            case BUNDLE: 
            case BUNDLE_COLORABLE: {
                return bundleModel;
            }
            case ORIGINAL: {
                return model;
            }
            case ORIGINAL_LOW_DETAIL: {
                return modelLowDetail;
            }
        }
        throw new IllegalArgumentException("backpackMode set to invalid enum value!");
    }

    public static class_2960 getBackpackTexture() {
        switch (ActiveConfig.active().bagMode) {
            case BUNDLE: {
                return BackpackBundleModel.textureLocation;
            }
            case BUNDLE_COLORABLE: {
                return BackpackBundleModel.textureLocationColorable;
            }
            case ORIGINAL: {
                return BackpackModel.textureLocation;
            }
            case ORIGINAL_LOW_DETAIL: {
                return BackpackLowDetailModel.textureLocation;
            }
        }
        throw new IllegalArgumentException("backpackMode set to invalid enum value!");
    }

    public static class_1160 getBackpackColor() {
        if (ActiveConfig.active().bagMode.colorable) {
            class_1160 rgb = new class_1160((float)(ActiveConfig.active().bagColor >> 16), (float)(ActiveConfig.active().bagColor >> 8 & 0xFF), (float)(ActiveConfig.active().bagColor & 0xFF));
            rgb.method_4942(0.003921569f);
            return rgb;
        }
        return maxColor;
    }

    private class_243 getRightVec(BackpackInfo info) {
        class_1160 leftF = new class_1160(0.0f, 0.0f, 1.0f);
        leftF.method_19262(class_1160.field_20704.method_23626(1.5707964f));
        leftF.method_19262(class_1160.field_20707.method_23626(info.handRoll));
        leftF.method_19262(class_1160.field_20702.method_23626(info.handPitch));
        leftF.method_19262(class_1160.field_20704.method_23626(info.handYaw));
        return new class_243((double)leftF.method_4943(), (double)leftF.method_4945(), (double)leftF.method_4947());
    }

    private void calculatePositions(BackpackInfo info, IVRPlayer vrPlayer) {
        IVRData backpackController = vrPlayer.getController(this.getBagControllerNum());
        info.handPos = backpackController.position();
        info.handPitch = (float)Math.toRadians(backpackController.getPitch());
        info.handYaw = (float)Math.toRadians(backpackController.getYaw());
        info.handRoll = (float)Math.toRadians(backpackController.getRoll());
        info.lookVec = backpackController.getLookAngle();
        class_243 rightVec = this.getRightVec(info).method_1021(0.25);
        if (this.leftHanded()) {
            rightVec = rightVec.method_1021(-1.0);
        }
        class_243 leftVec = rightVec.method_1021(-1.0);
        class_1160 downVecF = new class_1160(0.0f, -1.0f, 0.0f);
        downVecF.method_19262(class_1160.field_20707.method_23626(info.handRoll));
        downVecF.method_19262(class_1160.field_20702.method_23626(info.handPitch));
        downVecF.method_19262(class_1160.field_20704.method_23626(info.handYaw));
        info.downVec = new class_243((double)downVecF.method_4943(), (double)downVecF.method_4945(), (double)downVecF.method_4947());
        info.backVec = info.lookVec.method_1021(-1.0);
        info.renderPos = info.handPos.method_1019(info.downVec.method_1021(0.75));
        info.renderPos = info.renderPos.method_1019(info.backVec.method_1021(0.16666666666666666));
        info.renderPos = info.renderPos.method_1019(rightVec);
        info.rgb = ImmersiveBackpack.getBackpackColor();
        info.centerTopPos = info.renderPos.method_1019(info.downVec.method_1021(-0.7));
        class_243 leftOffset = leftVec.method_1021(0.375);
        class_243 rightOffset = rightVec.method_1021(0.375);
        double tbSpacing = 0.09375;
        class_243 topOffset = info.lookVec.method_1021(tbSpacing);
        class_243 botOffset = info.backVec.method_1021(tbSpacing);
        class_243 pos = info.centerTopPos;
        class_243[] positions = new class_243[]{pos.method_1019(leftOffset).method_1019(topOffset), pos.method_1019(topOffset), pos.method_1019(rightOffset).method_1019(topOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(botOffset), pos.method_1019(botOffset), pos.method_1019(rightOffset).method_1019(botOffset)};
        int start = 9 * info.topRow;
        int end = start + 8;
        int midStart = 9 * info.getMidRow();
        int midEnd = midStart + 8;
        class_243 downOne = info.downVec.method_1021(0.105);
        class_243 downTwo = downOne.method_1021(2.0);
        for (int i = 0; i <= 26; ++i) {
            class_243 posRaw = positions[i % 9];
            class_243 yDown = this.inRange(i, start, end) ? class_243.field_1353 : (this.inRange(i, midStart, midEnd) ? downOne : downTwo);
            class_243 slotPos = posRaw;
            slotPos = slotPos.method_1019(yDown);
            info.setPosition(i, slotPos);
            info.setHitbox(i, OBBFactory.instance().create(class_238.method_30048((class_243)info.getPosition(i), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        }
        class_243 upVec = info.downVec.method_1021(-1.0);
        double upMult = 0.05;
        class_243 leftCraftingPos = info.centerTopPos.method_1019(rightVec.method_1021(1.25)).method_1019(upVec.method_1021(upMult));
        class_243 rightCraftingPos = info.centerTopPos.method_1019(rightVec.method_1021(1.75)).method_1019(upVec.method_1021(upMult));
        class_243 centerCraftingPos = info.centerTopPos.method_1019(rightVec.method_1021(1.5)).method_1019(upVec.method_1021(upMult));
        double craftingOffset = 0.625;
        class_243[] craftingPositions = new class_243[]{leftCraftingPos.method_1019(topOffset.method_1021(craftingOffset)), rightCraftingPos.method_1019(topOffset.method_1021(craftingOffset)), leftCraftingPos.method_1019(botOffset.method_1021(craftingOffset)), rightCraftingPos.method_1019(botOffset.method_1021(craftingOffset))};
        for (int i = 27; i <= 30; ++i) {
            info.setPosition(i, craftingPositions[i - 27]);
            info.setHitbox(i, OBBFactory.instance().create(class_238.method_30048((class_243)info.getPosition(i), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        }
        info.setPosition(31, centerCraftingPos.method_1019(upVec.method_1021(0.125)));
        info.setHitbox(31, OBBFactory.instance().create(class_238.method_30048((class_243)info.getPosition(31), (double)0.1f, (double)0.1f, (double)0.1f), info.handPitch, info.handYaw, info.handRoll));
        info.setInputSlots();
    }

    private boolean leftHanded() {
        boolean useSwappedHands;
        boolean vrLeftHanded = VRPlugin.API.isLeftHanded((class_1657)class_310.method_1551().field_1724);
        return vrLeftHanded != (useSwappedHands = ActiveConfig.active().swapBagHand);
    }

    private int getBagControllerNum() {
        return ActiveConfig.active().swapBagHand ? 0 : 1;
    }
}

