/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.compat.util;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.compat.CompatModuleClient;
import com.hammy275.immersivemc.common.compat.CompatData;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.packet.ConfigSyncPacket;
import com.hammy275.immersivemc.server.ServerSubscriber;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CompatModule<T>
implements InvocationHandler {
    private final T module;
    private final CompatData compatData;
    private final Map<String, Method> methods = new HashMap<String, Method>();

    private CompatModule(T module, CompatData compatData) {
        this.module = module;
        this.compatData = compatData;
        for (Method method : module.getClass().getMethods()) {
            this.methods.put(method.getName(), method);
        }
    }

    public static <T extends I, I> I create(T module, Class<I> interfaceClass, CompatData compatData) {
        return (I)Proxy.newProxyInstance(CompatModule.class.getClassLoader(), new Class[]{interfaceClass}, new CompatModule<T>(module, compatData));
    }

    public static <S extends NetworkStorage> ImmersiveHandler<S> create(ImmersiveHandler<S> handler, CompatData compatData) {
        return CompatModule.create(handler, ImmersiveHandler.class, compatData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        method = this.methods.get(method.getName());
        try {
            return method.invoke(this.module, args);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            System.out.println(sw);
            if (Platform.isClient()) {
                CompatModuleClient.disableClient(this.compatData);
            } else {
                CompatModule.handleDisableServer(this.compatData, ServerSubscriber.server);
            }
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            if (returnType.isPrimitive()) {
                return Array.get(Array.newInstance(returnType, 1), 0);
            }
            if (returnType.isEnum()) {
                return returnType.getEnumConstants()[0];
            }
            if (returnType == String.class) {
                return "";
            }
            return null;
        }
    }

    public static void handleDisableServer(CompatData compatData, MinecraftServer server) {
        compatData.configSetter().accept(ActiveConfig.FILE_SERVER, false);
        ActiveConfig.remergeAllConfigs();
        server.method_3760().method_14571().forEach(ConfigSyncPacket::syncConfigToPlayer);
        if (!server.method_3760().method_14571().isEmpty()) {
            server.method_9203(CompatModule.getErrorMessage(compatData.friendlyName()), ((class_3222)server.method_3760().method_14571().get(0)).method_5667());
        }
        server.method_3760().method_14571().forEach(player -> player.method_9203(CompatModule.getErrorMessage(compatData.friendlyName()), player.method_5667()));
    }

    public static class_2561 getErrorMessage(String friendlyName) {
        return new class_2588("message.immersivemc.compat_error", new Object[]{friendlyName});
    }
}

