/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.obb;

import com.hammy275.immersivemc.common.obb.OBBRot;
import com.hammy275.immersivemc.common.obb.RotType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1158;
import net.minecraft.class_1160;

public class OBBRotList {
    private final List<OBBRot> rotList = new ArrayList<OBBRot>();

    private OBBRotList() {
    }

    private OBBRotList(OBBRot ... rotations) {
        for (OBBRot rot : rotations) {
            if (rot == null) {
                throw new NullPointerException("Cannot add null rotation to rotation list.");
            }
            if (rot.rot() == 0.0f) continue;
            this.rotList.add(rot);
        }
    }

    private OBBRotList(List<OBBRot> rotList) {
        this.rotList.addAll(rotList);
    }

    public OBBRotList addRot(float rot, RotType rotType) {
        if (rot != 0.0f) {
            this.rotList.add(new OBBRot(rot, rotType));
        }
        return this;
    }

    public OBBRotList addRot(double rot, RotType rotType) {
        return this.addRot((float)rot, rotType);
    }

    public List<OBBRot> getRotations() {
        return new ArrayList<OBBRot>(this.rotList);
    }

    public class_1158 asQuaternion() {
        class_1158 quaternion = new class_1158(0.0f, 0.0f, 0.0f, 1.0f);
        for (OBBRot rot : this.rotList) {
            switch (rot.rotType()) {
                case PITCH: {
                    quaternion.method_4925(class_1160.field_20702.method_23626(rot.rot()));
                    break;
                }
                case YAW: {
                    quaternion.method_4925(class_1160.field_20704.method_23626(rot.rot()));
                    break;
                }
                case ROLL: {
                    quaternion.method_4925(class_1160.field_20707.method_23626(rot.rot()));
                }
            }
        }
        return quaternion;
    }

    public OBBRotList copy() {
        return new OBBRotList(this.rotList);
    }

    public static OBBRotList create() {
        return new OBBRotList();
    }

    public static OBBRotList create(OBBRot ... rotations) {
        return new OBBRotList(rotations);
    }
}

