/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.fabric;

import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.compat.lootr.LootrCompat;
import com.hammy275.immersivemc.common.compat.util.CompatModule;
import com.hammy275.immersivemc.mixin.ChestLidControllerAccessor;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import net.minecraft.class_3908;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.api.inventory.ILootrInventory;
import org.jetbrains.annotations.Nullable;

public class LootrCompatImpl
implements LootrCompat {
    private static final Class<?> lootrBarrelBlockEntityClass = LootrCompatImpl.getLootrClassMaybeRenamed("net.zestyblaze.lootr.blocks.entities.LootrBarrelBlockEntity");
    private static final Method barrelStartOpen = LootrCompatImpl.getMethod(lootrBarrelBlockEntityClass, "startOpen", class_1657.class);
    private static final Method barrelStopOpen = LootrCompatImpl.getMethod(lootrBarrelBlockEntityClass, "stopOpen", class_1657.class);
    private static final Class<?> lootrChestBlockEntityClass = LootrCompatImpl.getLootrClassMaybeRenamed("net.zestyblaze.lootr.blocks.entities.LootrChestBlockEntity");
    private static final Field chestChestLidController = LootrCompatImpl.getDeclaredField(lootrChestBlockEntityClass, "chestLidController");
    private static final Class<?> lootrShulkerBlockEntityClass = LootrCompatImpl.getLootrClassMaybeRenamed("net.zestyblaze.lootr.blocks.entities.LootrShulkerBlockEntity");
    private static final Method shulkerBoxStartOpen = LootrCompatImpl.getMethod(lootrShulkerBlockEntityClass, "startOpen", class_1657.class);
    private static final Method shulkerBoxStopOpen = LootrCompatImpl.getMethod(lootrShulkerBlockEntityClass, "stopOpen", class_1657.class);
    private static final Method shulkerBoxIsClosed = LootrCompatImpl.getMethod(lootrShulkerBlockEntityClass, "isClosed", new Class[0]);

    private LootrCompatImpl() {
    }

    public static LootrCompat makeCompatImpl() {
        return CompatModule.create(new LootrCompatImpl(), LootrCompat.class, Lootr.compatData);
    }

    @Override
    @Nullable
    public class_1263 getContainer(class_3222 player, class_2338 pos) {
        class_1937 level = player.field_6002;
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof ILootBlockEntity) {
            ILootBlockEntity lootBE = (ILootBlockEntity)blockEntity;
            if (blockEntity instanceof class_2621) {
                class_2621 rcbe = (class_2621)blockEntity;
                class_3908 provider = LootrAPI.getModdedMenu((class_1937)level, (UUID)lootBE.getTileId(), (class_2338)pos, (class_3222)player, (class_2621)rcbe, (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)lootBE).unpackLootTable(arg_0, arg_1, arg_2, arg_3), () -> ((ILootBlockEntity)lootBE).getTable(), () -> ((ILootBlockEntity)lootBE).getSeed());
                if (provider instanceof ILootrInventory) {
                    ILootrInventory inventory = (ILootrInventory)provider;
                    return inventory;
                }
            }
        }
        return null;
    }

    @Override
    public void markOpener(class_1657 player, class_2338 pos) {
        class_2586 blockEntity = player.field_6002.method_8321(pos);
        if (blockEntity instanceof ILootBlockEntity) {
            ILootBlockEntity lootBE = (ILootBlockEntity)blockEntity;
            if (player.field_6002.field_9236) {
                lootBE.setOpened(true);
            } else {
                lootBE.getOpeners().add(player.method_5667());
                blockEntity.method_5431();
            }
        }
    }

    @Override
    public boolean isLootrContainer(class_2338 pos, class_1937 level) {
        return level.method_8320(pos).method_26164(LootrCompat.BLOCK_TAG);
    }

    @Override
    public boolean openLootrBarrel(class_2338 pos, class_1657 player, boolean nowOpen) {
        class_2586 barrel = player.field_6002.method_8321(pos);
        if (lootrBarrelBlockEntityClass.isInstance(barrel)) {
            if (nowOpen) {
                LootrCompatImpl.invoke(barrelStartOpen, barrel, player);
                ChestToOpenSet.openChest(player, pos);
            } else {
                LootrCompatImpl.invoke(barrelStopOpen, barrel, player);
                ChestToOpenSet.closeChest(player, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean openLootrShulkerBox(class_2338 pos, class_1657 player, boolean nowOpen) {
        class_2586 be = player.field_6002.method_8321(pos);
        if (lootrShulkerBlockEntityClass.isInstance(be)) {
            if (nowOpen) {
                LootrCompatImpl.invoke(shulkerBoxStartOpen, be, player);
                ChestToOpenSet.openChest(player, pos);
            } else {
                LootrCompatImpl.invoke(shulkerBoxStopOpen, be, player);
                ChestToOpenSet.closeChest(player, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen(class_2338 pos, class_1657 player) {
        class_2586 be = player.field_6002.method_8321(pos);
        if (lootrShulkerBlockEntityClass.isInstance(be)) {
            return (Boolean)LootrCompatImpl.invoke(shulkerBoxIsClosed, be, new Object[0]) == false;
        }
        if (lootrBarrelBlockEntityClass.isInstance(be)) {
            return (Boolean)player.field_6002.method_8320(pos).method_11654((class_2769)class_3708.field_18006);
        }
        if (lootrChestBlockEntityClass.isInstance(be)) {
            try {
                return ((ChestLidControllerAccessor)chestChestLidController.get(be)).immersiveMC$getShouldBeOpen();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private static Class<?> getLootrClassMaybeRenamed(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ignored) {
            try {
                return Class.forName(name.replace(".blocks.", ".block."));
            }
            catch (ClassNotFoundException ignored2) {
                return null;
            }
        }
    }

    @Nullable
    private static Method getMethod(@Nullable Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    @Nullable
    private static Field getDeclaredField(@Nullable Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ignored) {
            return null;
        }
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return null;
        }
    }
}

