/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.api_impl;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SharedNetworkStoragesImpl
implements SharedNetworkStorages {
    public static final SharedNetworkStoragesImpl INSTANCE = new SharedNetworkStoragesImpl();
    private Map<class_2960, Map<class_2338, NetworkStorage>> storages = new HashMap<class_2960, Map<class_2338, NetworkStorage>>();

    @Override
    public <S extends NetworkStorage> S getOrCreate(class_1937 level, class_2338 pos, ImmersiveHandler<S> handler) {
        S storage = this.get(level, pos, handler);
        if (storage == null) {
            storage = handler.getEmptyNetworkStorage();
            this.storages.get(level.method_27983().method_29177()).put(pos, (NetworkStorage)storage);
        }
        return storage;
    }

    @Override
    @Nullable
    public <S extends NetworkStorage> S get(class_1937 level, class_2338 pos, ImmersiveHandler<S> handler) {
        NetworkStorage storage;
        Map innerMap = this.storages.computeIfAbsent(level.method_27983().method_29177(), rl -> new HashMap());
        S emptyStorage = handler.getEmptyNetworkStorage();
        if (innerMap.containsKey(pos) && (storage = (NetworkStorage)innerMap.get(pos)).getClass() == emptyStorage.getClass()) {
            return (S)storage;
        }
        return null;
    }

    @Override
    public <S extends NetworkStorage> void remove(class_1937 level, class_2338 pos, ImmersiveHandler<S> handler) {
        NetworkStorage storage;
        Map<class_2338, NetworkStorage> innerMap = this.storages.get(level.method_27983().method_29177());
        if (innerMap != null && (storage = innerMap.get(pos)) != null && storage.getClass() == handler.getEmptyNetworkStorage().getClass()) {
            innerMap.remove(pos);
        }
    }

    @Override
    public <S extends NetworkStorage> List<S> getAll(Class<S> storageClass) {
        return this.storages.values().stream().map(Map::values).flatMap(Collection::stream).filter(storage -> storage.getClass() == storageClass).map(storage -> storage).toList();
    }

    public void clear() {
        this.storages.clear();
    }
}

