/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersive;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.ImmersiveBuilderImpl;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoImpl;
import com.hammy275.immersivemc.client.immersive.TextData;
import com.hammy275.immersivemc.client.immersive.info.BuiltImmersiveInfoImpl;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.util.Util;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class BuiltImmersiveImpl<E, S extends NetworkStorage>
implements BuiltImmersive<E, S> {
    private final ImmersiveBuilderImpl<E, S> builder;
    private final List<BuiltImmersiveInfo<E>> infos = new ArrayList<BuiltImmersiveInfo<E>>();

    public BuiltImmersiveImpl(ImmersiveBuilderImpl<E, S> builder) {
        this.builder = builder;
    }

    @Override
    public ImmersiveHandler<S> getHandler() {
        return this.builder.handler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return this.builder.configScreenInfo;
    }

    @Override
    public boolean shouldRender(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.getHandler().isValidBlock(info.getBlockPosition(), (class_1937)class_310.method_1551().field_1687) && info.hasHitboxes() && info.airCheckPassed && this.builder.extraRenderReady.apply(info) != false;
    }

    @Override
    public void tick(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        ++info.ticksExisted;
        class_2350 currentDir = switch (this.builder.positioningMode) {
            case HitboxPositioningMode.HORIZONTAL_BLOCK_FACING, HitboxPositioningMode.BLOCK_FACING_NEG_X, HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED, HitboxPositioningMode.TOP_BLOCK_FACING -> info.immersiveDir;
            case HitboxPositioningMode.TOP_PLAYER_FACING, HitboxPositioningMode.HORIZONTAL_PLAYER_FACING, HitboxPositioningMode.PLAYER_FACING_NO_DOWN -> ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
            case HitboxPositioningMode.TOP_LITERAL -> null;
            case HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING -> Util.getForwardFromPlayerUpAndDownFilterBlockFacing((class_1657)class_310.method_1551().field_1724, info.getBlockPosition(), true);
            default -> throw new UnsupportedOperationException("Facing direction for positioning mode " + this.builder.positioningMode + " unimplemented!");
        };
        boolean differentDirs = info.immersiveDir != currentDir;
        info.immersiveDir = currentDir;
        boolean didRecalc = false;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.constantOffset || differentDirs || !hitbox.calcDone() || this.builder.slotActive != null || hitbox.vrMovementInfo != null || hitbox.textSupplier != null || !hitbox.forcedUpDownRenderDirConstant) {
                didRecalc = true;
                if (this.builder.slotActive == null || this.builder.slotActive.apply(info, i).booleanValue()) {
                    hitbox.recalculate((class_1937)class_310.method_1551().field_1687, this.builder.positioningMode, info);
                } else {
                    hitbox.forceNull();
                }
            }
            if (!differentDirs) continue;
            hitbox.onOrientationChange();
        }
        if (this.builder.dragHitboxCreator != null) {
            info.dragHitbox = this.builder.dragHitboxCreator.apply(info);
        } else if (didRecalc) {
            boolean validBox = false;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (RelativeHitboxInfoImpl hitbox : info.hitboxes) {
                if (!hitbox.hasAABB() || !hitbox.isInput) continue;
                class_238 aabb = hitbox.getAABB();
                minX = Math.min(minX, aabb.field_1323);
                minY = Math.min(minY, aabb.field_1322);
                minZ = Math.min(minZ, aabb.field_1321);
                maxX = Math.max(maxX, aabb.field_1320);
                maxY = Math.max(maxY, aabb.field_1325);
                maxZ = Math.max(maxZ, aabb.field_1324);
                validBox = true;
            }
            info.dragHitbox = validBox ? new class_238(minX, minY, minZ, maxX, maxY, maxZ).method_1014(0.0625) : null;
        }
        info.airCheckPassed = this.airCheck(info);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(this.getLightPositions(info));
    }

    @Nullable
    public class_238 getDragHitbox(BuiltImmersiveInfo<E> info) {
        return this.asImpl(info).dragHitbox;
    }

    @Override
    public boolean isInputHitbox(BuiltImmersiveInfo<E> infoIn, int hitboxIndex) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return info.hitboxes.get((int)hitboxIndex).isInput;
    }

    @Override
    public void render(BuiltImmersiveInfo<E> infoIn, class_4587 stack, ImmersiveRenderHelpers helpers, float partialTick) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        float size = ImmersiveRenderHelpers.instance().getTransitionMultiplier(info.ticksExisted) * this.builder.renderSize;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.hasAABB()) continue;
            class_238 renderBox = hitbox.getRenderHitbox(partialTick);
            class_243 renderPos = renderBox.method_1005();
            if (hitbox.holdsItems && (hitbox.renderItem || hitbox.item == null || hitbox.item.method_7960())) {
                Float spinDegrees;
                Float f = spinDegrees = hitbox.itemSpins ? Float.valueOf((float)info.ticksExisted % 100.0f * 3.6f) : null;
                if (hitbox.item == null || hitbox.item.method_7960()) {
                    if (hitbox.isInput && this.builder.slotRendersItemGuide.apply(info, i).booleanValue()) {
                        helpers.renderItemGuide(stack, (BoundingBox)renderBox, info.isSlotHovered(i), info.light);
                    }
                } else {
                    float renderSize = size * hitbox.itemRenderSizeMultiplier;
                    if (info.isSlotHovered(i)) {
                        renderSize *= ImmersiveRenderHelpers.instance().hoverScaleSizeMultiplier();
                    }
                    helpers.renderItem(hitbox.item, stack, renderSize, (BoundingBox)renderBox, hitbox.renderItemCount, info.light, spinDegrees, info.immersiveDir, hitbox.getUpDownRenderDir());
                }
            } else {
                helpers.renderHitbox(stack, (BoundingBox)renderBox);
            }
            for (TextData data : hitbox.getTextData()) {
                helpers.renderText(data.text(), stack, renderPos.method_1019(data.offset()), info.light, 0.02f);
            }
        }
        if (info.dragHitbox != null) {
            helpers.renderHitbox(stack, (BoundingBox)info.dragHitbox, false, 0.0f, 1.0f, 1.0f);
        }
        this.builder.extraRenderer.render(infoIn, stack, helpers, partialTick, info.light);
    }

    @Override
    public BuiltImmersiveInfo<E> buildInfo(class_2338 pos, class_1937 level) {
        BuiltImmersiveInfoImpl info;
        class_2680 state = level.method_8320(pos);
        if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (state.method_11654((class_2769)class_2741.field_12555) != class_2738.field_12471) {
                info.immersiveDir = info.immersiveDir.method_10153();
            }
        } else {
            throw new UnsupportedOperationException("Tracking for positioning mode " + this.builder.positioningMode + " unimplemented!");
        }
        return info;
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(BuiltImmersiveInfo<E> info) {
        return this.builder.blockRightClickWhenGUIClickDisabled;
    }

    @Override
    public Collection<BuiltImmersiveInfo<E>> getTrackedObjects() {
        return this.infos;
    }

    @Override
    public int handleHitboxInteract(BuiltImmersiveInfo<E> infoIn, class_746 player, List<Integer> hitboxIndices, class_1268 hand, boolean modifierPressed) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.builder.hitboxInteractHandler.apply(info, (class_1657)player, hitboxIndices, hand, modifierPressed);
    }

    private boolean airCheck(BuiltImmersiveInfo<E> infoIn) {
        AbstractCollection positions;
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.airCheckPositionOffsets.isEmpty()) {
            positions = new HashSet();
            info.hitboxes.forEach(hitbox -> {
                if (hitbox.hasAABB()) {
                    positions.addAll(Util.allPositionsWithAABB(hitbox.getAABB()));
                }
            });
            class_2338 immersivePos = info.getBlockPosition();
            positions.remove(immersivePos);
            positions.removeIf(pos -> Math.abs(pos.method_10263() - immersivePos.method_10263()) > 1 || Math.abs(pos.method_10264() - immersivePos.method_10264()) > 1 || Math.abs(pos.method_10260() - immersivePos.method_10260()) > 1);
        } else {
            positions = new ArrayList();
            for (class_2382 offset : this.builder.airCheckPositionOffsets) {
                positions.add(info.getBlockPosition().method_10081(offset));
            }
        }
        for (class_2338 pos2 : positions) {
            class_238 shape;
            double volume;
            class_2680 state = class_310.method_1551().field_1687.method_8320(pos2);
            if (state.method_45474() || !((volume = (shape = state.method_26218((class_1922)class_310.method_1551().field_1687, pos2).method_1107()).method_17939() * shape.method_17940() * shape.method_17941()) > 0.3333333333333333)) continue;
            return false;
        }
        return true;
    }

    public List<class_2338> getLightPositions(BuiltImmersiveInfo<E> info) {
        if (this.builder.lightPositionOffsets.size() > 1) {
            ArrayList<class_2338> lightPositions = new ArrayList<class_2338>();
            for (class_2382 offset : this.builder.lightPositionOffsets) {
                lightPositions.add(info.getBlockPosition().method_10081(offset));
            }
            return lightPositions;
        }
        if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            ArrayList<class_2338> lightPositions = new ArrayList<class_2338>();
            class_2350.class_2351 ignored = ((class_2350)class_310.method_1551().field_1724.field_6002.method_8320(info.getBlockPosition()).method_11654((class_2769)class_2318.field_10927)).method_10166();
            for (class_2350 dir : class_2350.values()) {
                if (dir.method_10166() == ignored) continue;
                lightPositions.add(info.getBlockPosition().method_10093(dir));
            }
            return lightPositions;
        }
        return List.of(this.getLightPos(info));
    }

    public class_2338 getLightPos(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.lightPositionOffsets.isEmpty()) {
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
                return info.getBlockPosition().method_10093(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
                return info.getBlockPosition().method_10084();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
                return info.getBlockPosition().method_10084();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
                return info.getBlockPosition().method_10084();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
                return info.getBlockPosition().method_10093(ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
                return info.getBlockPosition().method_10093(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
                return info.getBlockPosition().method_10093(Util.getForwardFromPlayerUpAndDown((class_1657)class_310.method_1551().field_1724, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
                class_2680 state = class_310.method_1551().field_1687.method_8320(info.getBlockPosition());
                return switch ((class_2738)state.method_11654((class_2769)class_2741.field_12555)) {
                    default -> throw new IncompatibleClassChangeError();
                    case class_2738.field_12475 -> info.getBlockPosition().method_10084();
                    case class_2738.field_12471 -> info.getBlockPosition().method_10093((class_2350)state.method_11654((class_2769)class_2741.field_12481));
                    case class_2738.field_12473 -> info.getBlockPosition().method_10074();
                };
            }
            throw new UnsupportedOperationException("Light pos for positioning mode " + this.builder.positioningMode + " unimplemented!");
        }
        return info.getBlockPosition().method_10081(this.builder.lightPositionOffsets.get(0));
    }

    @Override
    public void processStorageFromNetwork(BuiltImmersiveInfo<E> infoIn, S storage) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (storage instanceof ListOfItemsStorage) {
            ListOfItemsStorage itemsStorage = (ListOfItemsStorage)storage;
            for (int i = 0; i < itemsStorage.getItems().size(); ++i) {
                info.hitboxes.get((int)i).item = itemsStorage.getItems().get(i);
            }
        } else if (storage instanceof ItemStorage) {
            ItemStorage iws = (ItemStorage)storage;
            for (int i = 0; i < iws.getNumItems(); ++i) {
                info.hitboxes.get((int)i).item = iws.getItem(i);
            }
        }
        if (this.builder.extraStorageConsumer != null) {
            this.builder.extraStorageConsumer.accept(storage, info);
        }
    }

    @Override
    public boolean isVROnly() {
        return this.builder.vrOnly;
    }

    @Override
    public <T extends NetworkStorage> ImmersiveBuilderImpl<E, T> getBuilderClone(ImmersiveHandler<T> newHandler) {
        return this.builder.copy((ImmersiveHandler)newHandler);
    }

    private BuiltImmersiveInfoImpl<E> asImpl(BuiltImmersiveInfo<E> infoIn) {
        return (BuiltImmersiveInfoImpl)infoIn;
    }
}

