/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookHelpers;
import com.hammy275.immersivemc.client.immersive.info.LecternInfo;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.PageTurnPacket;
import com.hammy275.immersivemc.common.util.PosRot;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ImmersiveLectern
implements Immersive<LecternInfo, LecternData<CommonBookData>> {
    protected final List<LecternInfo> infos = new ArrayList<LecternInfo>();

    @Override
    public Collection<LecternInfo> getTrackedObjects() {
        return this.infos;
    }

    @Override
    public LecternInfo buildInfo(class_2338 pos, class_1937 level) {
        return new LecternInfo(pos);
    }

    @Override
    public int handleHitboxInteract(LecternInfo info, class_746 player, List<Integer> hitboxIndices, class_1268 hand, boolean modifierPressed) {
        int hitboxIndex = hitboxIndices.get(0);
        if (hitboxIndex <= 2) {
            if (VRPluginVerify.clientInVR()) {
                return 0;
            }
            if (hitboxIndex <= 1) {
                Network.INSTANCE.sendToServer(new PageTurnPacket(info.getBlockPosition(), hitboxIndex == 1));
                return ImmersiveClientConstants.instance().defaultCooldown();
            }
        } else if (!VRPluginVerify.clientInVR()) {
            ((ClientBookData)info.lecternData.bookData).interactables.get(hitboxIndex - 3).interact((ClientBookData)info.lecternData.bookData, info.lecternData.getLecternPosRot(info.getBlockPosition()), null);
            return ImmersiveClientConstants.instance().defaultCooldown();
        }
        return -1;
    }

    @Override
    public boolean shouldRender(LecternInfo info) {
        return !info.lecternData.book.method_7960() && info.light > -1 && this.getHandler().isValidBlock(info.getBlockPosition(), (class_1937)class_310.method_1551().field_1687);
    }

    @Override
    public void render(LecternInfo info, class_4587 stack, ImmersiveRenderHelpers helpers, float partialTick) {
        ((ClientBookData)info.lecternData.bookData).render(stack, info.light, info.lecternData.getLecternPosRot(info.getBlockPosition()));
    }

    @Override
    public void tick(LecternInfo info) {
        ++info.tickCount;
        ((ClientBookData)info.lecternData.bookData).interactables.clear();
        PosRot lecternPosRot = info.lecternData.getLecternPosRot(info.getBlockPosition());
        WrittenBookHelpers.addInteractablesForThisTick(info, lecternPosRot, true);
        WrittenBookHelpers.addInteractablesForThisTick(info, lecternPosRot, false);
        info.lecternData.tick((class_1657)class_310.method_1551().field_1724);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(info.getBlockPosition().method_10084());
        if (info.didClick) {
            ImmersiveClientLogicHelpers.instance().setCooldown(ImmersiveClientConstants.instance().defaultCooldown());
            info.didClick = false;
        }
    }

    @Nullable
    public class_238 getDragHitbox(LecternInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(LecternInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public ImmersiveHandler<LecternData<CommonBookData>> getHandler() {
        return ImmersiveHandlers.lecternHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("lectern", () -> new class_1799((class_1935)class_1802.field_16312), config -> config.useLecternImmersive, (config, newVal) -> {
            config.useLecternImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(LecternInfo info) {
        return false;
    }

    @Override
    public void processStorageFromNetwork(LecternInfo info, LecternData<CommonBookData> storage) {
        info.setBook(storage.book);
        info.lecternData.mergeFromServer(storage);
        this.tick(info);
        --info.tickCount;
    }

    @Override
    public boolean isVROnly() {
        return false;
    }
}

