/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.book;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.client.immersive.book.BookInteractable;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookDataHolder;
import com.hammy275.immersivemc.client.workaround.ClickHandlerScreen;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WrittenBookHelpers {
    public static ClientBookData makeClientBookData(WrittenBookDataHolder dataHolder) {
        ClientBookData bookData = new ClientBookData();
        class_3872.class_3931 access = class_3872.class_3931.method_17562((class_1799)dataHolder.getBook());
        bookData.renderables.add(new BookTextRenderer(isLeftPage -> {
            int rightMod = isLeftPage != false ? 0 : 1;
            return access.method_17563(dataHolder.getData().getLeftPageIndex() + rightMod);
        }, -0.0025f, new class_243(0.0, 1.0, 0.0)));
        bookData.setMaxLeftPageIndex(Math.max(access.method_17560() - 1, 0));
        return bookData;
    }

    public static void addInteractablesForThisTick(WrittenBookDataHolder dataHolder, PosRot bookPosRot, boolean isLeft) {
        if (dataHolder.getData().getPageChangeState() != PageChangeState.NONE) {
            return;
        }
        class_3872.class_3931 access = class_3872.class_3931.method_17562((class_1799)dataHolder.getBook());
        if (access == null) {
            return;
        }
        ClientBookData data = dataHolder.getData();
        class_243 pageUp = bookPosRot.getLookAngle();
        class_243 pageDown = pageUp.method_1021(-1.0);
        class_243 left = data.getLeftRightVector(bookPosRot, true);
        class_243 right = data.getLeftRightVector(bookPosRot, false);
        class_243 away = data.getAwayVector(bookPosRot);
        class_243 leftStartMove = isLeft ? left.method_1021(0.288) : class_243.field_1353;
        class_243 pos = bookPosRot.position().method_1019(pageUp.method_1021(0.25)).method_1019(leftStartMove).method_1019(away.method_1021(0.09375)).method_1019(pageDown.method_1021((double)(9.0f * Math.abs(-0.0025f))));
        class_327 font = class_310.method_1551().field_1772;
        int rightMod = isLeft ? 0 : 1;
        class_5348 rawText = access.method_17563(dataHolder.getData().getLeftPageIndex() + rightMod);
        List text = font.method_1728(rawText, 114);
        for (int lineNum = 0; lineNum < text.size(); ++lineNum) {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            class_243 leftPos = pos.method_1019(pageDown.method_1021((double)((float)(26 + lineNum * 9) * Math.abs(-0.0025f))));
            ArrayList chars = new ArrayList();
            ((class_5481)text.get(lineNum)).accept((charIndex, style, codePoint) -> {
                chars.add(new Pair((Object)new StringBuilder().appendCodePoint(codePoint).toString(), (Object)style));
                return true;
            });
            double pixelsMoved = 0.0;
            class_2583 styleForPositions = null;
            ArrayList<class_243> stylePositions = new ArrayList<class_243>();
            double length = 0.0;
            for (Pair c : chars) {
                String str = (String)c.getFirst();
                class_2583 style2 = (class_2583)c.getSecond();
                pixelsMoved += (double)font.method_1727(str) / 2.0;
                double halfCharWidth = (double)font.method_1727(str) / 2.0 * (double)Math.abs(-0.0025f);
                leftPos = leftPos.method_1019(right.method_1021(halfCharWidth));
                if (style2.method_10970() != null) {
                    class_243 placePos;
                    double pixelMovedRatio = pixelsMoved / 114.0;
                    if (pixelMovedRatio < 0.5 && isLeft || pixelMovedRatio > 0.5 && !isLeft) {
                        pixelMovedRatio = pixelMovedRatio > 0.5 ? (pixelMovedRatio -= 0.5) : 0.5 - pixelMovedRatio;
                        placePos = leftPos.method_1019(away.method_1021(0.09375).method_1021(pixelMovedRatio / 2.0));
                    } else {
                        pixelMovedRatio = pixelMovedRatio > 0.5 ? (pixelMovedRatio -= 0.5) : 0.5 - pixelMovedRatio;
                        placePos = leftPos.method_1019(away.method_1021(0.09375).method_1021(-pixelMovedRatio / 2.0));
                    }
                    if (style2 != styleForPositions) {
                        BookInteractable interactable = WrittenBookHelpers.makeInteractable(dataHolder, stylePositions, styleForPositions, length, bookPosRot, isLeft);
                        if (interactable != null) {
                            data.interactables.add(interactable);
                        }
                        styleForPositions = style2;
                        stylePositions.clear();
                    } else {
                        stylePositions.add(placePos);
                        length += halfCharWidth * 2.0;
                    }
                }
                pixelsMoved += (double)font.method_1727(str) / 2.0;
                leftPos = leftPos.method_1019(right.method_1021(halfCharWidth));
            }
            BookInteractable interactable = WrittenBookHelpers.makeInteractable(dataHolder, stylePositions, styleForPositions, length, bookPosRot, isLeft);
            if (interactable == null) continue;
            data.interactables.add(interactable);
        }
    }

    @Nullable
    private static BookInteractable makeInteractable(WrittenBookDataHolder holder, List<class_243> positions, class_2583 style, double length, PosRot hand, boolean isLeft) {
        if (style != null && style.method_10970() != null && !positions.isEmpty()) {
            class_243 centerPos = WrittenBookHelpers.getCenterPos(positions);
            return new BookStyleInteractable(holder, OBBFactory.instance().create(class_238.method_30048((class_243)centerPos, (double)length, (double)0.04, (double)0.02), Math.toRadians(hand.getPitch()), Math.toRadians(hand.getYaw()), (isLeft ? CommonBookData.leftPageRot : -CommonBookData.leftPageRot) + Math.toRadians(hand.getRoll())), style);
        }
        return null;
    }

    private static class_243 getCenterPos(List<class_243> positions) {
        int size = positions.size();
        if (size % 2 == 0) {
            class_243 a = positions.get(size / 2);
            class_243 b = positions.get(size / 2 - 1);
            return a.method_1019(b).method_1021(0.5);
        }
        return positions.get(size / 2);
    }

    public record BookTextRenderer(Function<Boolean, class_5348> textSupplier, float textStackScaleSize, class_243 offset) implements BookRenderable
    {
        @Override
        public void render(class_4587 stack, ClientBookData data, boolean leftPage, int light, PosRot bookPosRot) {
            stack.method_22905(this.textStackScaleSize, this.textStackScaleSize, this.textStackScaleSize);
            class_327 font = class_310.method_1551().field_1772;
            class_5348 textRaw = this.textSupplier.apply(leftPage);
            if (textRaw == null) {
                return;
            }
            List text = font.method_1728(textRaw, 114);
            int lineNum = 0;
            for (class_5481 seq : text) {
                font.method_22942(seq, -56.0f, (float)(32 + lineNum++ * 9), -16777216, false, stack.method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0, light);
            }
        }

        @Override
        public class_243 getStartOffset(ClientBookData data, boolean leftPage, PosRot bookPosRot) {
            return this.offset;
        }
    }

    private record BookStyleInteractable(WrittenBookDataHolder holder, OBB obb, class_2583 style) implements BookInteractable
    {
        @Override
        public OBB getOBB() {
            return this.obb;
        }

        @Override
        public void hover(ClientBookData data, PosRot bookPosRot, PosRot other) {
            class_243 pos = this.obb.getCenter();
            class_310.method_1551().field_1724.field_6002.method_8406((class_2394)new class_2390(new Vector3f(0.0f, 0.0f, 1.0f), 0.2f), pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
        }

        @Override
        public void interact(ClientBookData data, PosRot bookPosRot, PosRot other) {
            class_2558 clickEvent = this.style.method_10970();
            if (clickEvent != null) {
                String eventValue = clickEvent.method_10844();
                if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
                    try {
                        int newPageNum = Integer.parseInt(eventValue) - 1;
                        data.setPage(newPageNum);
                        this.holder.onPageChangeStyleClick(newPageNum);
                    }
                    catch (Exception newPageNum) {}
                } else {
                    ClickHandlerScreen tempScreen = new ClickHandlerScreen();
                    class_310.method_1551().method_1507((class_437)tempScreen);
                    tempScreen.method_25430(this.style);
                }
            }
        }
    }
}

