/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network;

import com.hammy275.immersivemc.ImmersiveMC;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.BackpackInfo;
import com.hammy275.immersivemc.client.immersive.info.BeaconInfo;
import com.hammy275.immersivemc.client.subscribe.ClientLogicSubscriber;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.network.packet.BeaconDataPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRRumble;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class NetworkClientHandlers {
    public static void checkHandlerMatch(List<class_2960> serverHandlerIDs) {
        HashMap clientHandlers = new HashMap();
        ImmersiveHandlers.HANDLERS.forEach(handler -> clientHandlers.put(handler.getID(), handler));
        List<class_2960> serverOnly = serverHandlerIDs.stream().filter(id -> !clientHandlers.containsKey(id)).toList();
        List<class_2960> clientOnly = clientHandlers.entrySet().stream().filter(entry -> !serverHandlerIDs.contains(entry.getKey()) && !((ImmersiveHandler)entry.getValue()).clientAuthoritative()).map(Map.Entry::getKey).toList();
        if (!serverOnly.isEmpty() || !clientOnly.isEmpty()) {
            if (!serverOnly.isEmpty()) {
                ImmersiveMC.LOGGER.error("The following Immersives were on the server, but not in your game:");
                ImmersiveMC.LOGGER.error(String.join((CharSequence)", ", serverOnly.stream().map(class_2960::toString).toList()));
            }
            if (!clientOnly.isEmpty()) {
                ImmersiveMC.LOGGER.error("The following Immersives are in your game, but not on the server even though they're required to be:");
                ImmersiveMC.LOGGER.error(String.join((CharSequence)", ", clientOnly.stream().map(class_2960::toString).toList()));
            }
            HashSet missingModIDs = new HashSet();
            serverOnly.forEach(id -> missingModIDs.add(id.method_12836()));
            clientOnly.forEach(id -> missingModIDs.add(id.method_12836()));
            class_310.method_1551().method_1562().method_10839((class_2561)class_2561.method_43469((String)"message.immersivemc.missing_immersives", (Object[])new Object[]{String.join((CharSequence)", ", missingModIDs)}));
        }
    }

    public static void setBeaconData(BeaconDataPacket packet) {
        for (BeaconInfo info : Immersives.immersiveBeacon.getTrackedObjects()) {
            if (!packet.pos.equals((Object)info.getBlockPosition())) continue;
            info.effectSelected = packet.powerIndex;
            info.regenSelected = packet.useRegen;
        }
    }

    public static void setBackpackOutput(class_1799 output) {
        if (Immersives.immersiveBackpack.getTrackedObjects().size() > 0) {
            BackpackInfo info = (BackpackInfo)Immersives.immersiveBackpack.getTrackedObjects().get(0);
            info.craftingOutput = output;
        }
    }

    public static <NS extends NetworkStorage> void handleReceiveInvData(NS storage, class_2338 pos, ImmersiveHandler<NS> handler) {
        ImmersiveInfo info;
        Objects.requireNonNull(storage);
        class_1937 level = class_310.method_1551().field_1724.field_6002;
        for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> immersive : Immersives.IMMERSIVES) {
            if (immersive.getHandler() != handler || !Util.isValidBlocks(handler, pos, level) || (info = ClientLogicSubscriber.doTrackIfNotTrackingAlready(immersive, pos, level)) == null) continue;
            NetworkClientHandlers.processStorageFromNetwork(immersive, info, storage);
        }
        for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
            if (abstractPlayerAttachmentImmersive.getHandler() != handler || !abstractPlayerAttachmentImmersive.shouldTrack(pos, level) || (info = abstractPlayerAttachmentImmersive.refreshOrTrackObject(pos, level)) == null) continue;
            abstractPlayerAttachmentImmersive.processStorageFromNetwork((AbstractPlayerAttachmentInfo)((Object)info), storage);
        }
    }

    private static <I extends ImmersiveInfo, NS extends NetworkStorage> void processStorageFromNetwork(Immersive<?, ?> immersive, I info, NS storage) {
        Immersive<?, ?> immersiveCast = immersive;
        immersiveCast.processStorageFromNetwork(info, storage);
    }

    public static void doDoubleRumble(float duration) {
        VRRumble.doubleRumbleIfVR((class_1657)class_310.method_1551().field_1724, duration);
    }
}

