/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class BeaconDataPacket {
    private static final int speedId = class_7923.field_41174.method_10206((Object)class_1294.field_5904);
    private static final int hasteId = class_7923.field_41174.method_10206((Object)class_1294.field_5917);
    private static final int resistId = class_7923.field_41174.method_10206((Object)class_1294.field_5907);
    private static final int jumpId = class_7923.field_41174.method_10206((Object)class_1294.field_5913);
    private static final int strengthId = class_7923.field_41174.method_10206((Object)class_1294.field_5910);
    private static final int regenId = class_7923.field_41174.method_10206((Object)class_1294.field_5924);
    public final class_2338 pos;
    public final int powerIndex;
    public final boolean useRegen;

    public static BeaconDataPacket fromBeacon(class_2580 beacon) {
        BeaconBlockEntityMixin accessor = (BeaconBlockEntityMixin)beacon;
        int primaryId = class_7923.field_41174.method_10206((Object)accessor.immersiveMC$getPrimaryPower());
        int powerIndex = -1;
        if (primaryId == speedId) {
            powerIndex = 0;
        } else if (primaryId == hasteId) {
            powerIndex = 1;
        } else if (primaryId == resistId) {
            powerIndex = 2;
        } else if (primaryId == jumpId) {
            powerIndex = 3;
        } else if (primaryId == strengthId) {
            powerIndex = 4;
        }
        return new BeaconDataPacket(beacon.method_11016(), powerIndex, class_7923.field_41174.method_10206((Object)accessor.immersiveMC$getSecondaryPower()) == regenId);
    }

    public BeaconDataPacket(class_2338 pos, int powerIndex, boolean useRegen) {
        this.pos = pos;
        this.powerIndex = powerIndex;
        this.useRegen = useRegen;
    }

    public BeaconDataPacket(class_2338 pos) {
        this.pos = pos;
        this.powerIndex = -2;
        this.useRegen = false;
    }

    public static void encode(BeaconDataPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos).writeInt(packet.powerIndex).writeBoolean(packet.useRegen);
    }

    public static BeaconDataPacket decode(class_2540 buffer) {
        return new BeaconDataPacket(buffer.method_10811(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(BeaconDataPacket packet, class_3222 player) {
        if (player == null) {
            NetworkClientHandlers.setBeaconData(packet);
        } else {
            class_2586 class_25862 = player.method_14220().method_8321(packet.pos);
            if (class_25862 instanceof class_2580) {
                class_2580 beacon = (class_2580)class_25862;
                Network.INSTANCE.sendToPlayer(player, BeaconDataPacket.fromBeacon(beacon));
            }
        }
    }
}

