/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3956;

public class CampfireTracker
extends AbstractTracker {
    public static final Map<String, CookInfo> cookTime = new HashMap<String, CookInfo>();

    public CampfireTracker() {
        ServerTrackerInit.playerTrackers.add(this);
    }

    @Override
    protected void tick(class_1657 player) {
        CookInfo info = cookTime.get(player.method_7334().getName());
        if (info == null) {
            return;
        }
        for (int c = 0; c <= 1; ++c) {
            class_1799 toSmelt = c == 0 ? player.method_5998(class_1268.field_5808) : player.method_5998(class_1268.field_5810);
            Optional recipe = player.field_6002.method_8433().method_8132(class_3956.field_17549, (class_1263)new class_1277(new class_1799[]{toSmelt}), player.field_6002);
            if (recipe.isPresent() && info.get(c) >= ((class_3920)recipe.get()).method_8167() / 2) {
                toSmelt.method_7934(1);
                boolean didGive = player.method_31548().method_7394(((class_3920)recipe.get()).method_8110(player.field_6002.method_30349()).method_7972());
                if (!didGive) {
                    Util.placeLeftovers(player, ((class_3920)recipe.get()).method_8110(player.field_6002.method_30349()).method_7972());
                }
                cookTime.remove(player.method_7334().getName());
                continue;
            }
            if (!recipe.isPresent() || ThreadLocalRandom.current().nextInt(4) != 0) continue;
            class_243 pos = VRPlugin.API.getVRPlayer(player).getController(c).position();
            class_1937 class_19372 = player.field_6002;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.01, 0.01, 0.01, 0.0);
        }
    }

    @Override
    protected boolean shouldTick(class_1657 player) {
        if (!ActiveConfig.FILE_SERVER.useCampfireImmersive) {
            return false;
        }
        if (!VRPluginVerify.hasAPI) {
            return false;
        }
        if (!VRPlugin.API.playerInVR(player)) {
            return false;
        }
        if (!ActiveConfig.getConfigForPlayer((class_1657)player).useCampfireImmersive) {
            return false;
        }
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        boolean mainRes = false;
        boolean offRes = false;
        for (int c = 0; c <= 1; ++c) {
            class_1799 stackOld;
            class_2680 campfire;
            IVRData controller = vrPlayer.getController(c);
            class_2338 pos = class_2338.method_49638((class_2374)controller.position());
            if (!(player.field_6002.method_8320(pos).method_26204() instanceof class_3922) && !(player.field_6002.method_8320(pos.method_10074()).method_26204() instanceof class_3922) || !((Boolean)(campfire = player.field_6002.method_8320(pos).method_26204() instanceof class_3922 ? player.field_6002.method_8320(pos) : player.field_6002.method_8320(pos.method_10074())).method_11654((class_2769)class_3922.field_17352)).booleanValue()) continue;
            class_1799 stackNew = c == 0 ? player.method_5998(class_1268.field_5808) : player.method_5998(class_1268.field_5810);
            CookInfo info = cookTime.get(player.method_7334().getName());
            if (info == null) {
                info = new CookInfo();
                cookTime.put(player.method_7334().getName(), info);
            }
            if (stackNew == (stackOld = info.getStack(c)) || stackOld.method_7960()) {
                info.add(c, 1);
                if (c == 0) {
                    mainRes = true;
                } else {
                    offRes = true;
                }
            }
            info.setStack(c, stackNew);
        }
        return mainRes || offRes;
    }

    public static class CookInfo {
        protected int mainHand = 0;
        protected int offHand = 0;
        public class_1799 stackHeldMain = class_1799.field_8037;
        public class_1799 stackHeldOff = class_1799.field_8037;

        public void set(int controller, int value) {
            if (controller == 0) {
                this.mainHand = value;
            } else {
                this.offHand = value;
            }
        }

        public int get(int controller) {
            return controller == 0 ? this.mainHand : this.offHand;
        }

        public void add(int controller, int amount) {
            this.set(controller, this.get(controller) + amount);
        }

        public class_1799 getStack(int controller) {
            return controller == 0 ? this.stackHeldMain : this.stackHeldOff;
        }

        public void setStack(int controller, class_1799 stack) {
            if (controller == 0) {
                this.stackHeldMain = stack;
            } else {
                this.stackHeldOff = stack;
            }
        }

        public String toString() {
            return "Main Hand: " + this.stackHeldMain + " w/ " + this.mainHand + " ticks\nOff Hand: " + this.stackHeldOff + " w/ " + this.offHand + " ticks";
        }
    }
}

