/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveMCClientRegistration;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.CommonConstants;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.datafixers.util.Pair;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientUtil {
    public static final int maxLight = LightTexture.m_109885_((int)15, (int)15);
    public static int immersiveLeftClickCooldown = 0;

    public static Vec3 lerpVec3(Vec3 start, Vec3 end, float partialTick) {
        return new Vec3(Mth.m_14139_((double)partialTick, (double)start.f_82479_, (double)end.f_82479_), Mth.m_14139_((double)partialTick, (double)start.f_82480_, (double)end.f_82480_), Mth.m_14139_((double)partialTick, (double)start.f_82481_, (double)end.f_82481_));
    }

    public static Pair<Vec3, Vec3> getVRStartAndEnd(int device) {
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_);
        IVRData vrData = device == -1 ? vrPlayer.getHMD() : vrPlayer.getController(device);
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        Vec3 start = vrData.position();
        Vec3 look = vrData.getLookAngle();
        Vec3 end = vrData.position().m_82520_(look.f_82479_ * dist, look.f_82480_ * dist, look.f_82481_ * dist);
        return new Pair((Object)start, (Object)end);
    }

    public static void clearDisabledImmersives() {
        for (Immersive<? extends ImmersiveInfo, ? extends NetworkStorage> immersive : Immersives.IMMERSIVES) {
            if (immersive.getHandler().enabledInConfig((Player)Minecraft.m_91087_().f_91074_)) continue;
            immersive.getTrackedObjects().clear();
        }
        for (AbstractPlayerAttachmentImmersive abstractPlayerAttachmentImmersive : Immersives.IMMERSIVE_ATTACHMENTS) {
            if (abstractPlayerAttachmentImmersive.enabledInConfig()) continue;
            abstractPlayerAttachmentImmersive.clearImmersives();
        }
    }

    public static ImmersiveConfigScreenInfo createConfigScreenInfo(String keyName, Supplier<ItemStack> optionItem, Function<ActiveConfig, Boolean> configGetter, BiConsumer<ActiveConfig, Boolean> configSetter) {
        return ImmersiveMCClientRegistration.instance().createConfigScreenInfoOneItem("immersivemc", "config.immersivemc." + keyName, optionItem, (Component)Component.m_237115_((String)("config.immersivemc." + keyName + ".desc")), () -> (Boolean)configGetter.apply(ConfigScreen.getAdjustingConfig()), newVal -> configSetter.accept(ConfigScreen.getAdjustingConfig(), (Boolean)newVal));
    }

    public static Vec3 playerPos() {
        return Minecraft.m_91087_().f_91074_.m_20318_(Minecraft.m_91087_().m_91296_());
    }

    public static Tuple<Vec3, Vec3> getStartAndEndOfLookTrace(Player player) {
        BlockHitResult bhr;
        Vec3 viewVec;
        Vec3 start;
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        if (VRPluginVerify.clientInVR()) {
            start = VRPlugin.API.getVRPlayer(player).getController0().position();
            viewVec = VRPlugin.API.getVRPlayer(player).getController0().getLookAngle();
        } else {
            start = player.m_20299_(1.0f);
            viewVec = player.m_20252_(1.0f);
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof BlockHitResult && (bhr = (BlockHitResult)hitResult).m_6662_() == HitResult.Type.BLOCK) {
            dist = bhr.m_82450_().m_82554_(start);
        }
        Vec3 end = start.m_82520_(viewVec.f_82479_ * dist, viewVec.f_82480_ * dist, viewVec.f_82481_ * dist);
        return new Tuple((Object)start, (Object)end);
    }

    public static Direction getClosestDirection(Vec3 velocity) {
        double max = Math.max(Math.abs(velocity.f_82479_), Math.max(Math.abs(velocity.f_82480_), Math.abs(velocity.f_82481_)));
        if (max == Math.abs(velocity.f_82479_)) {
            return velocity.f_82479_ < 0.0 ? Direction.WEST : Direction.EAST;
        }
        if (max == Math.abs(velocity.f_82480_)) {
            return velocity.f_82480_ < 0.0 ? Direction.DOWN : Direction.UP;
        }
        return velocity.f_82481_ < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static void openBag(Player player) {
        if (VRPluginVerify.hasAPI) {
            if (VRPlugin.API.playerInVR(player)) {
                if (VRPlugin.API.apiActive(player)) {
                    Immersives.immersiveBackpack.doTrack();
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"message.immersivemc.no_api_server"));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"message.immersivemc.not_in_vr"));
            }
        } else {
            player.m_213846_((Component)Component.m_237110_((String)"message.immersivemc.no_api", (Object[])new Object[]{CommonConstants.vrAPIVersionAsString(), CommonConstants.firstNonCompatibleFutureVersionAsString()}));
        }
    }

    @Nullable
    public static <I extends ImmersiveInfo> I findImmersive(Immersive<I, ?> immersive, BlockPos pos) {
        for (ImmersiveInfo info : immersive.getTrackedObjects()) {
            if (!Util.getValidBlocks(immersive.getHandler(), info.getBlockPosition(), (Level)Minecraft.m_91087_().f_91073_).contains(pos)) continue;
            return (I)info;
        }
        return null;
    }
}

