/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import java.util.LinkedList;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class LastClientVRData {
    private static final LinkedList<IVRPlayer> lastPlayers = new LinkedList();
    private static final LinkedList<Vec3> lastPositions = new LinkedList();

    public static void addLastTick(IVRPlayer player) {
        lastPlayers.addFirst(player);
        if (lastPlayers.size() > 5) {
            lastPlayers.removeLast();
        }
        if (Minecraft.m_91087_().f_91074_ != null) {
            lastPositions.addFirst(ClientUtil.playerPos());
            if (lastPositions.size() > 5) {
                lastPositions.removeLast();
            }
        }
    }

    public static boolean hasPlayerTicksAgo(int ticksAgo) {
        return lastPlayers.size() >= ticksAgo;
    }

    public static IVRPlayer getPlayer(int ticksAgo) {
        if (ticksAgo > 5) {
            throw new IllegalArgumentException("Only holds data for past 5 ticks");
        }
        if (ticksAgo == 0) {
            return VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_);
        }
        return lastPlayers.get(ticksAgo - 1);
    }

    public static boolean canGetVelocityChange() {
        return LastClientVRData.hasPlayerTicksAgo(2);
    }

    public static Vec3 changeForVelocity(VRType type) {
        IVRData last = type == VRType.HMD ? LastClientVRData.getPlayer(2).getHMD() : LastClientVRData.getPlayer(2).getController(type.index);
        IVRData current = type == VRType.HMD ? VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getHMD() : VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(type.index);
        Vec3 lastPlayerPos = lastPositions.get(1);
        Vec3 currentPlayerPos = ClientUtil.playerPos();
        Vec3 posDiff = currentPlayerPos.m_82546_(lastPlayerPos);
        return current.position().m_82546_(last.position()).m_82546_(posDiff);
    }

    public static enum VRType {
        HMD(-1),
        C0(0),
        C1(1);

        public int index;

        private VRType(int index) {
            this.index = index;
        }
    }
}

