/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.api_impl;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.immersive.SwapTracker;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ImmersiveRenderHelpersImpl
implements ImmersiveRenderHelpers {
    public static final ImmersiveRenderHelpers INSTANCE = new ImmersiveRenderHelpersImpl();

    @Override
    public void renderItemWithInfo(ItemStack item, PoseStack stack, float size, boolean renderItemCounts, int light, ImmersiveInfo info, boolean shouldRenderItemGuide, int hitboxIndex, @Nullable Float spinDegrees, @Nullable Direction facing, @Nullable Direction upDown) {
        boolean hovered;
        HitboxInfo hitbox = info.getAllHitboxes().get(hitboxIndex);
        float partialTick = Minecraft.m_91087_().m_91296_();
        boolean bl = hovered = info.getSlotHovered(0) == hitboxIndex || info.getSlotHovered(1) == hitboxIndex || SwapTracker.slotHovered(info, hitboxIndex);
        if (item == null || item.m_41619_()) {
            if (shouldRenderItemGuide) {
                this.renderItemGuide(stack, hitbox.getRenderHitbox(partialTick), hovered, light);
            }
        } else {
            long ticksExisted = info.getTicksExisted();
            size = ticksExisted < 10L ? (size *= this.getTransitionMultiplier(info.getTicksExisted())) : (hovered ? size * 1.25f : size);
            BoundingBox bbox = hitbox.getRenderHitbox(partialTick);
            this.renderItem(item, stack, size, bbox, renderItemCounts, light, spinDegrees, facing, upDown);
        }
    }

    @Override
    public void renderItem(ItemStack item, PoseStack stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, size, hitbox, renderItemCounts, light, null, null, null);
    }

    @Override
    public void renderItem(ItemStack item, PoseStack stack, float size, BoundingBox hitbox, boolean renderItemCounts, int light, @Nullable Float spinDegrees, @Nullable Direction facing, @Nullable Direction upDown) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 pos = BoundingBox.getCenter(hitbox);
        if (item != null && item != ItemStack.f_41583_) {
            stack.m_85836_();
            stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
            stack.m_85841_(size, size, size);
            Vec3 textPos = pos;
            float degreesRotation = 0.0f;
            if (spinDegrees != null) {
                degreesRotation = spinDegrees.floatValue();
            } else if (facing == Direction.WEST) {
                degreesRotation = 90.0f;
            } else if (facing == Direction.SOUTH) {
                degreesRotation = 180.0f;
            } else if (facing == Direction.EAST) {
                degreesRotation = 270.0f;
            }
            int upDownRot = 0;
            if (upDown == Direction.UP) {
                upDownRot = 90;
                textPos = textPos.m_82520_(0.0, 0.15, 0.0);
            } else if (upDown == Direction.DOWN) {
                upDownRot = 270;
                textPos = textPos.m_82520_(0.0, -0.15, 0.0);
            } else if (facing == Direction.WEST) {
                textPos = textPos.m_82520_(-0.15, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                textPos = textPos.m_82520_(0.0, 0.0, 0.15);
            } else if (facing == Direction.EAST) {
                textPos = textPos.m_82520_(0.15, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                textPos = textPos.m_82520_(0.0, 0.0, -0.15);
            } else if (facing == null) {
                Vec3 textMove;
                this.faceTowardsPlayer(stack, BoundingBox.getCenter(hitbox));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                if (VRPluginVerify.hasAPI && VRPluginVerify.clientInVR()) {
                    IVRPlayer textMovePlayer = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_) : VRPlugin.API.getRenderVRPlayer();
                    textMove = textMovePlayer.getHMD().getLookAngle();
                } else {
                    textMove = Minecraft.m_91087_().f_91074_.m_20154_();
                }
                textMove = textMove.m_82542_(-0.05, -0.05, -0.05);
                textPos = textPos.m_82549_(textMove);
            }
            if (facing != null) {
                stack.m_252781_(Axis.f_252436_.m_252977_(degreesRotation));
                stack.m_252781_(Axis.f_252529_.m_252977_((float)upDownRot));
            }
            ItemDisplayContext type = facing == null ? ItemDisplayContext.GROUND : ItemDisplayContext.FIXED;
            Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)Minecraft.m_91087_().f_91074_, item, type, false, stack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), (Level)Minecraft.m_91087_().f_91073_, light, OverlayTexture.f_118083_, 0);
            stack.m_85849_();
            if (renderItemCounts && item.m_41613_() > 1) {
                this.renderText((Component)Component.m_237113_((String)String.valueOf(item.m_41613_())), stack, textPos, light, facing == null ? 0.0025f : 0.01f);
            }
        }
        this.renderHitbox(stack, hitbox);
    }

    @Override
    public void renderItemGuide(PoseStack stack, BoundingBox hitbox, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, 0.2f, isSelected, light));
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender) {
        this.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        this.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    @Override
    public void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        if ((Minecraft.m_91087_().m_91290_().m_114377_() || alwaysRender) && hitbox != null) {
            if (hitbox.isAABB()) {
                Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
                stack.m_85836_();
                stack.m_85837_(-renderInfo.m_90583_().f_82479_, -renderInfo.m_90583_().f_82480_, -renderInfo.m_90583_().f_82481_);
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)hitbox.asAABB(), (float)red, (float)green, (float)blue, (float)alpha);
                stack.m_85849_();
            } else {
                OBBClientUtil.renderOBB(stack, hitbox.asOBB(), alwaysRender, red, green, blue, alpha);
            }
        }
    }

    @Override
    public void renderText(Component text, PoseStack stack, Vec3 pos, int light, float textSize) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        stack.m_85836_();
        stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
        stack.m_252781_(renderInfo.m_253121_());
        stack.m_85841_(-(textSize *= ActiveConfig.active().textScale), -textSize, -textSize);
        Font font = Minecraft.m_91087_().f_91062_;
        float size = (float)(-font.m_92852_((FormattedText)text)) / 2.0f;
        font.m_272077_(text, size, 0.0f, -1, false, stack.m_85850_().m_252922_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, light);
        stack.m_85849_();
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, Vec3 pos, float size, int light, @Nullable Direction facing) {
        this.renderImage(stack, imageLocation, 0.0f, 0.0f, 1.0f, 1.0f, pos, size, light, facing);
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, Vec3 pos, float size, int light, @Nullable Direction facing) {
        this.renderImage(stack, imageLocation, minImageU, minImageV, maxImageU, maxImageV, pos, size, light, 0.0f, facing);
    }

    @Override
    public void renderImage(PoseStack stack, ResourceLocation imageLocation, float minImageU, float minImageV, float maxImageU, float maxImageV, Vec3 pos, float size, int light, float roll, @Nullable Direction facing) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        stack.m_85836_();
        stack.m_85837_(-renderInfo.m_90583_().f_82479_ + pos.f_82479_, -renderInfo.m_90583_().f_82480_ + pos.f_82480_, -renderInfo.m_90583_().f_82481_ + pos.f_82481_);
        stack.m_85841_(size, size, size);
        if (facing == Direction.WEST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        } else if (facing == Direction.SOUTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else if (facing == Direction.EAST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (facing == null) {
            this.faceTowardsPlayer(stack, pos);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        stack.m_252781_(Axis.f_252393_.m_252977_(roll));
        VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110458_((ResourceLocation)imageLocation));
        PoseStack.Pose lastPose = stack.m_85850_();
        Matrix4f pose = lastPose.m_252922_();
        Matrix3f normal = lastPose.m_252943_();
        consumer.m_252986_(pose, -0.5f, -0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minImageU, maxImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 0.5f, -0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxImageU, maxImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 0.5f, 0.75f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxImageU, minImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, -0.5f, 0.75f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minImageU, minImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        stack.m_85849_();
    }

    @Override
    public float getTransitionMultiplier(long ticksExisted) {
        return Math.min(1.0f, 0.1f * ((float)ticksExisted + Minecraft.m_91087_().m_91296_()));
    }

    @Override
    public float hoverScaleSizeMultiplier() {
        return 1.25f;
    }

    private void faceTowardsPlayer(PoseStack stack, Vec3 renderPos) {
        if (VRPluginVerify.clientInVR()) {
            Vec3 target = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getHMD().position() : VRPlugin.API.getRenderVRPlayer().getHMD().position();
            Vec3 ray = target.m_82546_(renderPos);
            Vec3 rayNoY = ray.m_82542_(1.0, 0.0, 1.0);
            OBBRotList rotList = OBBRotList.create().addRot(Math.atan2(ray.f_82481_, ray.f_82479_) + 1.5707963267948966, RotType.YAW).addRot(-Math.atan2(ray.f_82480_, rayNoY.m_82553_()), RotType.PITCH);
            stack.m_252781_(rotList.asQuaternion());
        } else {
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        }
    }
}

