/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersive;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.immersive.ImmersiveBuilderImpl;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoImpl;
import com.hammy275.immersivemc.client.immersive.TextData;
import com.hammy275.immersivemc.client.immersive.info.BuiltImmersiveInfoImpl;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class BuiltImmersiveImpl<E, S extends NetworkStorage>
implements BuiltImmersive<E, S> {
    private final ImmersiveBuilderImpl<E, S> builder;
    private final List<BuiltImmersiveInfo<E>> infos = new ArrayList<BuiltImmersiveInfo<E>>();

    public BuiltImmersiveImpl(ImmersiveBuilderImpl<E, S> builder) {
        this.builder = builder;
    }

    @Override
    public ImmersiveHandler<S> getHandler() {
        return this.builder.handler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return this.builder.configScreenInfo;
    }

    @Override
    public boolean shouldRender(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.getHandler().isValidBlock(info.getBlockPosition(), (Level)Minecraft.m_91087_().f_91073_) && info.hasHitboxes() && info.airCheckPassed && this.builder.extraRenderReady.apply(info) != false;
    }

    @Override
    public void tick(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        ++info.ticksExisted;
        Direction currentDir = switch (this.builder.positioningMode) {
            case HitboxPositioningMode.HORIZONTAL_BLOCK_FACING, HitboxPositioningMode.BLOCK_FACING_NEG_X, HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED, HitboxPositioningMode.TOP_BLOCK_FACING -> info.immersiveDir;
            case HitboxPositioningMode.TOP_PLAYER_FACING, HitboxPositioningMode.HORIZONTAL_PLAYER_FACING, HitboxPositioningMode.PLAYER_FACING_NO_DOWN -> ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
            case HitboxPositioningMode.TOP_LITERAL -> null;
            case HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING -> Util.getForwardFromPlayerUpAndDownFilterBlockFacing((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition(), true);
            default -> throw new UnsupportedOperationException("Facing direction for positioning mode " + this.builder.positioningMode + " unimplemented!");
        };
        boolean differentDirs = info.immersiveDir != currentDir;
        info.immersiveDir = currentDir;
        boolean didRecalc = false;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.constantOffset || differentDirs || !hitbox.calcDone() || this.builder.slotActive != null || hitbox.vrMovementInfo != null || hitbox.textSupplier != null || !hitbox.forcedUpDownRenderDirConstant) {
                didRecalc = true;
                if (this.builder.slotActive == null || this.builder.slotActive.apply(info, i).booleanValue()) {
                    hitbox.recalculate((Level)Minecraft.m_91087_().f_91073_, this.builder.positioningMode, info);
                } else {
                    hitbox.forceNull();
                }
            }
            if (!differentDirs) continue;
            hitbox.onOrientationChange();
        }
        if (this.builder.dragHitboxCreator != null) {
            info.dragHitbox = this.builder.dragHitboxCreator.apply(info);
        } else if (didRecalc) {
            boolean validBox = false;
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (RelativeHitboxInfoImpl hitbox : info.hitboxes) {
                if (!hitbox.hasAABB() || !hitbox.isInput) continue;
                AABB aabb = hitbox.getAABB();
                minX = Math.min(minX, aabb.f_82288_);
                minY = Math.min(minY, aabb.f_82289_);
                minZ = Math.min(minZ, aabb.f_82290_);
                maxX = Math.max(maxX, aabb.f_82291_);
                maxY = Math.max(maxY, aabb.f_82292_);
                maxZ = Math.max(maxZ, aabb.f_82293_);
                validBox = true;
            }
            info.dragHitbox = validBox ? new AABB(minX, minY, minZ, maxX, maxY, maxZ).m_82400_(0.0625) : null;
        }
        info.airCheckPassed = this.airCheck(info);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(this.getLightPositions(info));
    }

    @Nullable
    public AABB getDragHitbox(BuiltImmersiveInfo<E> info) {
        return this.asImpl(info).dragHitbox;
    }

    @Override
    public boolean isInputHitbox(BuiltImmersiveInfo<E> infoIn, int hitboxIndex) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return info.hitboxes.get((int)hitboxIndex).isInput;
    }

    @Override
    public void render(BuiltImmersiveInfo<E> infoIn, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        float size = ImmersiveRenderHelpers.instance().getTransitionMultiplier(info.ticksExisted) * this.builder.renderSize;
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            RelativeHitboxInfoImpl hitbox = info.hitboxes.get(i);
            if (!hitbox.hasAABB()) continue;
            AABB renderBox = hitbox.getRenderHitbox(partialTick);
            Vec3 renderPos = renderBox.m_82399_();
            if (hitbox.holdsItems && (hitbox.renderItem || hitbox.item == null || hitbox.item.m_41619_())) {
                Float spinDegrees;
                Float f = spinDegrees = hitbox.itemSpins ? Float.valueOf((float)info.ticksExisted % 100.0f * 3.6f) : null;
                if (hitbox.item == null || hitbox.item.m_41619_()) {
                    if (hitbox.isInput && this.builder.slotRendersItemGuide.apply(info, i).booleanValue()) {
                        helpers.renderItemGuide(stack, (BoundingBox)renderBox, info.isSlotHovered(i), info.light);
                    }
                } else {
                    float renderSize = size * hitbox.itemRenderSizeMultiplier;
                    if (info.isSlotHovered(i)) {
                        renderSize *= ImmersiveRenderHelpers.instance().hoverScaleSizeMultiplier();
                    }
                    helpers.renderItem(hitbox.item, stack, renderSize, (BoundingBox)renderBox, hitbox.renderItemCount, info.light, spinDegrees, info.immersiveDir, hitbox.getUpDownRenderDir());
                }
            } else {
                helpers.renderHitbox(stack, (BoundingBox)renderBox);
            }
            for (TextData data : hitbox.getTextData()) {
                helpers.renderText(data.text(), stack, renderPos.m_82549_(data.offset()), info.light, 0.02f);
            }
        }
        if (info.dragHitbox != null) {
            helpers.renderHitbox(stack, (BoundingBox)info.dragHitbox, false, 0.0f, 1.0f, 1.0f);
        }
        this.builder.extraRenderer.render(infoIn, stack, helpers, partialTick, info.light);
    }

    @Override
    public BuiltImmersiveInfo<E> buildInfo(BlockPos pos, Level level) {
        BuiltImmersiveInfoImpl info;
        BlockState state = level.m_8055_(pos);
        if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
        } else if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
            info = new BuiltImmersiveInfoImpl(this.builder.hitboxes, pos, this.builder.extraInfoDataClazz);
            info.immersiveDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            if (state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.WALL) {
                info.immersiveDir = info.immersiveDir.m_122424_();
            }
        } else {
            throw new UnsupportedOperationException("Tracking for positioning mode " + this.builder.positioningMode + " unimplemented!");
        }
        return info;
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(BuiltImmersiveInfo<E> info) {
        return this.builder.blockRightClickWhenGUIClickDisabled;
    }

    @Override
    public Collection<BuiltImmersiveInfo<E>> getTrackedObjects() {
        return this.infos;
    }

    @Override
    public int handleHitboxInteract(BuiltImmersiveInfo<E> infoIn, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        return this.builder.hitboxInteractHandler.apply(info, (Player)player, hitboxIndices, hand, modifierPressed);
    }

    private boolean airCheck(BuiltImmersiveInfo<E> infoIn) {
        AbstractCollection positions;
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.airCheckPositionOffsets.isEmpty()) {
            positions = new HashSet();
            info.hitboxes.forEach(hitbox -> {
                if (hitbox.hasAABB()) {
                    positions.addAll(Util.allPositionsWithAABB(hitbox.getAABB()));
                }
            });
            BlockPos immersivePos = info.getBlockPosition();
            positions.remove(immersivePos);
            positions.removeIf(pos -> Math.abs(pos.m_123341_() - immersivePos.m_123341_()) > 1 || Math.abs(pos.m_123342_() - immersivePos.m_123342_()) > 1 || Math.abs(pos.m_123343_() - immersivePos.m_123343_()) > 1);
        } else {
            positions = new ArrayList();
            for (Vec3i offset : this.builder.airCheckPositionOffsets) {
                positions.add(info.getBlockPosition().m_121955_(offset));
            }
        }
        for (BlockPos pos2 : positions) {
            AABB shape;
            double volume;
            BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(pos2);
            if (state.m_247087_() || !((volume = (shape = state.m_60808_((BlockGetter)Minecraft.m_91087_().f_91073_, pos2).m_83215_()).m_82362_() * shape.m_82376_() * shape.m_82385_()) > 0.3333333333333333)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getLightPositions(BuiltImmersiveInfo<E> info) {
        if (this.builder.lightPositionOffsets.size() > 1) {
            ArrayList<BlockPos> lightPositions = new ArrayList<BlockPos>();
            for (Vec3i offset : this.builder.lightPositionOffsets) {
                lightPositions.add(info.getBlockPosition().m_121955_(offset));
            }
            return lightPositions;
        }
        if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            ArrayList<BlockPos> lightPositions = new ArrayList<BlockPos>();
            Direction.Axis ignored = ((Direction)Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(info.getBlockPosition()).m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_();
            for (Direction dir : Direction.values()) {
                if (dir.m_122434_() == ignored) continue;
                lightPositions.add(info.getBlockPosition().m_121945_(dir));
            }
            return lightPositions;
        }
        return List.of(this.getLightPos(info));
    }

    public BlockPos getLightPos(BuiltImmersiveInfo<E> infoIn) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (this.builder.lightPositionOffsets.isEmpty()) {
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
                return info.getBlockPosition().m_121945_(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_PLAYER_FACING) {
                return info.getBlockPosition().m_7494_();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_LITERAL) {
                return info.getBlockPosition().m_7494_();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.TOP_BLOCK_FACING) {
                return info.getBlockPosition().m_7494_();
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
                return info.getBlockPosition().m_121945_(ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
                return info.getBlockPosition().m_121945_(info.immersiveDir);
            }
            if (this.builder.positioningMode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
                return info.getBlockPosition().m_121945_(Util.getForwardFromPlayerUpAndDown((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition()));
            }
            if (this.builder.positioningMode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
                BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition());
                return switch ((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)) {
                    default -> throw new IncompatibleClassChangeError();
                    case AttachFace.FLOOR -> info.getBlockPosition().m_7494_();
                    case AttachFace.WALL -> info.getBlockPosition().m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
                    case AttachFace.CEILING -> info.getBlockPosition().m_7495_();
                };
            }
            throw new UnsupportedOperationException("Light pos for positioning mode " + this.builder.positioningMode + " unimplemented!");
        }
        return info.getBlockPosition().m_121955_(this.builder.lightPositionOffsets.get(0));
    }

    @Override
    public void processStorageFromNetwork(BuiltImmersiveInfo<E> infoIn, S storage) {
        BuiltImmersiveInfoImpl<E> info = this.asImpl(infoIn);
        if (storage instanceof ListOfItemsStorage) {
            ListOfItemsStorage itemsStorage = (ListOfItemsStorage)storage;
            for (int i = 0; i < itemsStorage.getItems().size(); ++i) {
                info.hitboxes.get((int)i).item = itemsStorage.getItems().get(i);
            }
        } else if (storage instanceof ItemStorage) {
            ItemStorage iws = (ItemStorage)storage;
            for (int i = 0; i < iws.getNumItems(); ++i) {
                info.hitboxes.get((int)i).item = iws.getItem(i);
            }
        }
        if (this.builder.extraStorageConsumer != null) {
            this.builder.extraStorageConsumer.accept(storage, info);
        }
    }

    @Override
    public boolean isVROnly() {
        return this.builder.vrOnly;
    }

    @Override
    public <T extends NetworkStorage> ImmersiveBuilderImpl<E, T> getBuilderClone(ImmersiveHandler<T> newHandler) {
        return this.builder.copy((ImmersiveHandler)newHandler);
    }

    private BuiltImmersiveInfoImpl<E> asImpl(BuiltImmersiveInfo<E> infoIn) {
        return (BuiltImmersiveInfoImpl)infoIn;
    }
}

