/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.BeaconInfo;
import com.hammy275.immersivemc.client.immersive.info.HitboxItemPair;
import com.hammy275.immersivemc.client.immersive_item.HandImmersives;
import com.hammy275.immersivemc.client.immersive_item.info.HeldImageImmersiveInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.BeaconStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.BeaconConfirmPacket;
import com.hammy275.immersivemc.common.network.packet.BeaconDataPacket;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Instant;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveBeacon
extends AbstractImmersive<BeaconInfo, BeaconStorage> {
    private static final double effectHitboxSize = 0.2;
    private static final double displayHitboxSize = 0.2;
    private static final double effectCircleRadius = 0.2;
    private static final ResourceLocation[] effectLocations = new ResourceLocation[]{new ResourceLocation("textures/mob_effect/speed.png"), new ResourceLocation("textures/mob_effect/haste.png"), new ResourceLocation("textures/mob_effect/resistance.png"), new ResourceLocation("textures/mob_effect/jump_boost.png"), new ResourceLocation("textures/mob_effect/strength.png")};
    private static final ResourceLocation regenerationLocation = new ResourceLocation("textures/mob_effect/regeneration.png");
    private static final ResourceLocation confirmLocation = new ResourceLocation("immersivemc", "confirm.png");
    private static final ResourceLocation addLocation = new ResourceLocation("immersivemc", "add.png");

    @Override
    public BeaconInfo buildInfo(BlockPos pos, Level level) {
        BeaconInfo info = new BeaconInfo(pos);
        info.startMillis = Instant.now().toEpochMilli();
        Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int handleHitboxInteract(BeaconInfo info, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        ResourceLocation id = this.getHandler().getID();
        BiConsumer heldItemTicker = !ImmersiveBeacon.useGrabBeacon() ? null : (imageInfo, handData) -> {
            if (!Immersives.immersiveBeacon.getTrackedObjects().contains(info)) {
                imageInfo.shouldRemove = true;
            }
        };
        int hitboxIndex = hitboxIndices.get(0);
        if (hitboxIndex <= 4) {
            info.effectSelected = hitboxIndex;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, effectLocations[hitboxIndex], id, hitboxIndex, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 5) {
            info.regenSelected = true;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, regenerationLocation, id, 5, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 6) {
            info.regenSelected = false;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, addLocation, id, -1, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 7) {
            int effectId = -2;
            int secondaryId = -2;
            if (ImmersiveBeacon.useGrabBeacon()) {
                List<HeldImageImmersiveInfo<?>> heldImages = HandImmersives.heldImageImmersive.getHeldImages(id);
                if (!heldImages.isEmpty()) {
                    if (info.lastLevel < 4) {
                        secondaryId = -1;
                    } else {
                        secondaryId = heldImages.stream().filter(imageInfo -> {
                            int held = (Integer)imageInfo.heldData;
                            return (held == 5 || held == -1) && ((HitboxItemPair)info.hitboxes.get((int)7)).box != null && BoundingBox.contains(((HitboxItemPair)info.hitboxes.get((int)7)).box, VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(imageInfo.hand.ordinal()).position());
                        }).findFirst().map(heldImageImmersiveInfo -> (int)((Integer)heldImageImmersiveInfo.heldData)).orElse(-2);
                        if (secondaryId != -2) {
                            secondaryId = info.regenSelected ? BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19605_) : -1;
                        }
                    }
                    effectId = heldImages.stream().filter(imageInfo -> {
                        int held = (Integer)imageInfo.heldData;
                        return held >= 0 && held <= 4 && ((HitboxItemPair)info.hitboxes.get((int)7)).box != null && BoundingBox.contains(((HitboxItemPair)info.hitboxes.get((int)7)).box, VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(imageInfo.hand.ordinal()).position());
                    }).findFirst().map(heldImageImmersiveInfo -> (int)((Integer)heldImageImmersiveInfo.heldData)).orElse(-2);
                    if (effectId >= 0) {
                        info.effectSelected = effectId;
                    }
                }
            } else {
                effectId = info.effectSelected;
                int n = secondaryId = info.regenSelected ? BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19605_) : -1;
            }
            if (effectId < 0 || secondaryId == -2 || ((HitboxItemPair)info.hitboxes.get((int)8)).item.m_41619_()) return -1;
            effectId = info.getEffectId();
            Network.INSTANCE.sendToServer(new BeaconConfirmPacket(info.getBlockPosition(), effectId, secondaryId));
            VRRumble.rumbleIfVR((Player)Minecraft.m_91087_().f_91074_, 0, 0.15f);
            HandImmersives.heldImageImmersive.removeImages(id);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else {
            ImmersiveClientLogicHelpers.instance().sendSwapPacket(info.getBlockPosition(), List.of(Integer.valueOf(0)), hand, false);
        }
        return ImmersiveClientConstants.instance().defaultCooldown();
    }

    @Override
    public void tick(BeaconInfo info) {
        super.tick(info);
        for (HitboxItemPair pair : info.hitboxes) {
            pair.lastPos = pair.box == null ? null : BoundingBox.getCenter(pair.box);
        }
        this.setHitboxesAndPositions(info);
        info.lastPlayerDir = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition()).m_122424_();
    }

    @Nullable
    public AABB getDragHitbox(BeaconInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(BeaconInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public boolean shouldRender(BeaconInfo info) {
        return info.lastPlayerDir != null && info.areaAboveIsAir && info.hasHitboxes();
    }

    @Override
    public void render(BeaconInfo info, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        helpers.renderItemWithInfo(((HitboxItemPair)info.hitboxes.get((int)8)).item, stack, 0.42f, false, info.light, info, true, 8, null, info.lastPlayerDir.m_122424_(), null);
        float transitionMultiplier = helpers.getTransitionMultiplier(info.getTicksExisted());
        float effectSize = 0.2f * transitionMultiplier;
        for (int i = 0; i < info.hitboxes.size() - 1; ++i) {
            HitboxItemPair hitbox = (HitboxItemPair)info.hitboxes.get(i);
            if (hitbox.box == null) continue;
            BoundingBox renderHitbox = hitbox.getRenderHitbox(partialTick);
            helpers.renderHitbox(stack, renderHitbox);
            if (i > 4) continue;
            helpers.renderImage(stack, effectLocations[i], BoundingBox.getCenter(renderHitbox).m_82520_(0.0, -0.05, 0.0), info.effectSelected == i && !ImmersiveBeacon.useGrabBeacon() ? effectSize * 1.5f : (info.isSlotHovered(i) ? effectSize * 1.25f : effectSize), info.light, info.lastPlayerDir);
        }
        float displaySize = 0.2f * transitionMultiplier;
        if (info.effectSelected != -1 && !ImmersiveBeacon.useGrabBeacon()) {
            helpers.renderImage(stack, effectLocations[info.effectSelected], info.effectSelectedDisplayPos.m_82520_(0.0, -0.05, 0.0), displaySize, info.light, info.lastPlayerDir);
        }
        for (int i = 5; i <= 6; ++i) {
            HitboxItemPair hitbox = (HitboxItemPair)info.hitboxes.get(i);
            if (hitbox.box == null) continue;
            helpers.renderImage(stack, i == 5 ? regenerationLocation : addLocation, BoundingBox.getCenter(hitbox.box).m_82520_(0.0, -0.05, 0.0), info.isSlotHovered(i) ? displaySize * 1.25f : displaySize, info.light, info.lastPlayerDir);
        }
        HitboxItemPair hitbox7 = (HitboxItemPair)info.hitboxes.get(7);
        if (hitbox7.box != null && info.isEffectSelected()) {
            if (ImmersiveBeacon.useGrabBeacon()) {
                helpers.renderHitbox(stack, hitbox7.box);
            } else if (info.isReadyForConfirm()) {
                helpers.renderImage(stack, confirmLocation, BoundingBox.getCenter(hitbox7.box).m_82520_(0.0, -0.1, 0.0), info.isSlotHovered(7) ? 0.525f : 0.42f, info.light, info.lastPlayerDir);
            }
            Direction playerForward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition()).m_122424_();
            double xMult = 0.0;
            double zMult = 0.0;
            if (playerForward.m_122436_().m_123341_() != 0) {
                zMult = 1.0;
            } else {
                xMult = 1.0;
            }
            if (!ImmersiveBeacon.useGrabBeacon()) {
                helpers.renderHitbox(stack, (BoundingBox)AABB.m_165882_((Vec3)info.effectSelectedDisplayPos, (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                if (info.regenSelected && ((HitboxItemPair)info.hitboxes.get((int)5)).box != null) {
                    helpers.renderHitbox(stack, (BoundingBox)AABB.m_165882_((Vec3)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)5)).box), (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                } else if (!info.regenSelected && ((HitboxItemPair)info.hitboxes.get((int)6)).box != null) {
                    helpers.renderHitbox(stack, (BoundingBox)AABB.m_165882_((Vec3)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)6)).box), (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                }
            }
        }
    }

    @Override
    public ImmersiveHandler<BeaconStorage> getHandler() {
        return ImmersiveHandlers.beaconHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("beacon", () -> new ItemStack((ItemLike)Items.f_42065_), config -> config.useBeaconImmersive, (config, newVal) -> {
            config.useBeaconImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(BeaconInfo info) {
        return false;
    }

    @Override
    public void processStorageFromNetwork(BeaconInfo info, BeaconStorage storage) {
        ((HitboxItemPair)info.hitboxes.get((int)8)).item = storage.getItem(0);
    }

    @Override
    public boolean isVROnly() {
        return false;
    }

    protected void setHitboxesAndPositions(BeaconInfo info) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(info.getBlockPosition());
        if (blockEntity instanceof BeaconBlockEntity) {
            BeaconBlockEntity beacon = (BeaconBlockEntity)blockEntity;
            for (int x = -1; x <= 1; ++x) {
                for (int y = 1; y <= 2; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition().m_7918_(x, y, z)).m_247087_()) continue;
                        info.areaAboveIsAir = false;
                        return;
                    }
                }
            }
            info.areaAboveIsAir = true;
            Vec3 center = Vec3.m_82512_((Vec3i)info.getBlockPosition()).m_82520_(0.0, 1.0, 0.0);
            Direction beaconForward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
            Vec3 forwardFromBlockVec = new Vec3((double)beaconForward.m_122436_().m_123341_(), (double)beaconForward.m_122436_().m_123342_(), (double)beaconForward.m_122436_().m_123343_());
            Direction left = beaconForward.m_122427_();
            Vec3 leftVec = new Vec3((double)left.m_122436_().m_123341_(), (double)left.m_122436_().m_123342_(), (double)left.m_122436_().m_123343_());
            double itemHitboxSize = 0.42f;
            ((HitboxItemPair)info.hitboxes.get((int)8)).box = AABB.m_165882_((Vec3)Vec3.m_82539_((Vec3i)info.getBlockPosition()).m_82549_(forwardFromBlockVec.m_82490_(0.25).m_82549_(forwardFromBlockVec.m_82490_(itemHitboxSize / 2.0)).m_82520_(0.0, itemHitboxSize / 2.0 + 0.01, 0.0)), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize);
            ((HitboxItemPair)info.hitboxes.get((int)7)).box = ImmersiveBeacon.useGrabBeacon() ? new AABB(info.getBlockPosition()).m_82400_(0.001) : AABB.m_165882_((Vec3)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)8)).box).m_82520_(0.0, itemHitboxSize / 2.0 + 0.25, 0.0), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize);
            info.effectSelectedDisplayPos = center.m_82520_(0.0, 0.125, 0.0).m_82549_(leftVec.m_82490_(-0.3333333333333333)).m_82549_(forwardFromBlockVec.m_82490_(0.45));
            int beaconLevel = ((BeaconBlockEntityMixin)beacon).immersiveMC$getLevels();
            if (info.lastLevel > beaconLevel) {
                if (beaconLevel == 1 && info.effectSelected > 1) {
                    info.effectSelected = -1;
                } else if (beaconLevel == 2 && info.effectSelected == 4) {
                    info.effectSelected = -1;
                }
                Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
            }
            Direction centerDir = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition()).m_122424_();
            if (beaconLevel > 0) {
                info.levelWasNonzero = true;
                long timeSinceStartMilli = Instant.now().toEpochMilli() - info.startMillis;
                long millisPerRot = 9000L;
                Vec3 forwardPos = center.m_82549_(leftVec.m_82490_(0.8)).m_82520_(0.0, 0.2, 0.0).m_82549_(forwardFromBlockVec.m_82490_(0.45));
                double rot0 = (double)(timeSinceStartMilli % millisPerRot) / (double)millisPerRot * 2.0 * Math.PI;
                if (beaconLevel == 1) {
                    double rot1 = rot0 + Math.PI;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 2; i < info.hitboxes.size() - 2; ++i) {
                        ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                    }
                } else if (beaconLevel == 2) {
                    rotDiff = 1.5707963267948966;
                    double rot1 = rot0 + rotDiff;
                    rot2 = rot0 + 2.0 * rotDiff;
                    rot3 = rot0 + 3.0 * rotDiff;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)2)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot2, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)3)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot3, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 4; i < info.hitboxes.size() - 2; ++i) {
                        ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                    }
                } else {
                    rotDiff = 1.2566370614359172;
                    double rot1 = rot0 + rotDiff;
                    rot2 = rot0 + 2.0 * rotDiff;
                    rot3 = rot0 + 3.0 * rotDiff;
                    double rot4 = rot0 + 4.0 * rotDiff;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)2)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot2, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)3)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot3, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)4)).box = AABB.m_165882_((Vec3)this.posToRotatedPos(forwardPos, rot4, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    if (beaconLevel == 4) {
                        if (ImmersiveBeacon.useGrabBeacon()) {
                            Vec3 effectGrabPos = info.effectSelectedDisplayPos.m_82549_(leftVec.m_82490_(-0.25)).m_82520_(0.0, -0.1, 0.0);
                            ((HitboxItemPair)info.hitboxes.get((int)5)).box = AABB.m_165882_((Vec3)effectGrabPos.m_82549_(leftVec.m_82490_(-0.11)), (double)0.2, (double)0.2, (double)0.2);
                            ((HitboxItemPair)info.hitboxes.get((int)6)).box = AABB.m_165882_((Vec3)effectGrabPos.m_82549_(leftVec.m_82490_(0.11)), (double)0.2, (double)0.2, (double)0.2);
                        } else {
                            ((HitboxItemPair)info.hitboxes.get((int)5)).box = AABB.m_165882_((Vec3)info.effectSelectedDisplayPos.m_82549_(leftVec.m_82490_(-0.25)), (double)0.2, (double)0.2, (double)0.2);
                            ((HitboxItemPair)info.hitboxes.get((int)6)).box = AABB.m_165882_((Vec3)info.effectSelectedDisplayPos.m_82520_(0.0, -0.25, 0.0), (double)0.2, (double)0.2, (double)0.2);
                        }
                    } else {
                        for (int i = 5; i < info.hitboxes.size() - 2; ++i) {
                            ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                        }
                        info.regenSelected = false;
                    }
                }
            } else if (info.levelWasNonzero) {
                for (int i = 0; i < info.hitboxes.size(); ++i) {
                    ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                }
                info.effectSelected = -1;
                info.regenSelected = false;
                Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
            }
            if (centerDir != info.lastPlayerDir) {
                for (HitboxItemPair hitbox : info.hitboxes) {
                    hitbox.lastPos = null;
                }
            }
            info.lastLevel = beaconLevel;
        }
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            ((HitboxItemPair)info.hitboxes.get((int)i)).isTriggerHitbox = !ImmersiveBeacon.useGrabBeacon();
        }
    }

    private Vec3 posToRotatedPos(Vec3 forwardPos, double rotRad, Direction playerForwardDir) {
        double xz;
        Vec3 circleCenter = forwardPos.m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_()).m_82490_(0.2));
        Direction.Axis axisFacing = playerForwardDir.m_122434_();
        double d = xz = axisFacing == Direction.Axis.Z ? circleCenter.f_82479_ : circleCenter.f_82481_;
        if (playerForwardDir == Direction.NORTH || playerForwardDir == Direction.EAST) {
            rotRad = -rotRad;
        }
        double newXZ = xz + 0.2 * Math.cos(rotRad) - 0.2 * Math.sin(rotRad);
        double newY = circleCenter.f_82480_ + 0.2 * Math.sin(rotRad) + 0.2 * Math.cos(rotRad);
        if (axisFacing == Direction.Axis.Z) {
            return new Vec3(newXZ, newY, forwardPos.f_82481_);
        }
        return new Vec3(forwardPos.f_82479_, newY, newXZ);
    }

    public static boolean useGrabBeacon() {
        return VRPluginVerify.clientInVR() && ActiveConfig.active().useGrabBeaconInVR;
    }
}

