/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookHelpers;
import com.hammy275.immersivemc.client.immersive.info.LecternInfo;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.PageTurnPacket;
import com.hammy275.immersivemc.common.util.PosRot;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ImmersiveLectern
implements Immersive<LecternInfo, LecternData<CommonBookData>> {
    protected final List<LecternInfo> infos = new ArrayList<LecternInfo>();

    @Override
    public Collection<LecternInfo> getTrackedObjects() {
        return this.infos;
    }

    @Override
    public LecternInfo buildInfo(BlockPos pos, Level level) {
        return new LecternInfo(pos);
    }

    @Override
    public int handleHitboxInteract(LecternInfo info, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        int hitboxIndex = hitboxIndices.get(0);
        if (hitboxIndex <= 2) {
            if (VRPluginVerify.clientInVR()) {
                return 0;
            }
            if (hitboxIndex <= 1) {
                Network.INSTANCE.sendToServer(new PageTurnPacket(info.getBlockPosition(), hitboxIndex == 1));
                return ImmersiveClientConstants.instance().defaultCooldown();
            }
        } else if (!VRPluginVerify.clientInVR()) {
            ((ClientBookData)info.lecternData.bookData).interactables.get(hitboxIndex - 3).interact((ClientBookData)info.lecternData.bookData, info.lecternData.getLecternPosRot(info.getBlockPosition()), null);
            return ImmersiveClientConstants.instance().defaultCooldown();
        }
        return -1;
    }

    @Override
    public boolean shouldRender(LecternInfo info) {
        return !info.lecternData.book.m_41619_() && info.light > -1 && this.getHandler().isValidBlock(info.getBlockPosition(), (Level)Minecraft.m_91087_().f_91073_);
    }

    @Override
    public void render(LecternInfo info, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        ((ClientBookData)info.lecternData.bookData).render(stack, info.light, info.lecternData.getLecternPosRot(info.getBlockPosition()));
    }

    @Override
    public void tick(LecternInfo info) {
        ++info.tickCount;
        ((ClientBookData)info.lecternData.bookData).interactables.clear();
        PosRot lecternPosRot = info.lecternData.getLecternPosRot(info.getBlockPosition());
        WrittenBookHelpers.addInteractablesForThisTick(info, lecternPosRot, true);
        WrittenBookHelpers.addInteractablesForThisTick(info, lecternPosRot, false);
        info.lecternData.tick((Player)Minecraft.m_91087_().f_91074_);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(info.getBlockPosition().m_7494_());
        if (info.didClick) {
            ImmersiveClientLogicHelpers.instance().setCooldown(ImmersiveClientConstants.instance().defaultCooldown());
            info.didClick = false;
        }
    }

    @Nullable
    public AABB getDragHitbox(LecternInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(LecternInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public ImmersiveHandler<LecternData<CommonBookData>> getHandler() {
        return ImmersiveHandlers.lecternHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("lectern", () -> new ItemStack((ItemLike)Items.f_42774_), config -> config.useLecternImmersive, (config, newVal) -> {
            config.useLecternImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(LecternInfo info) {
        return false;
    }

    @Override
    public void processStorageFromNetwork(LecternInfo info, LecternData<CommonBookData> storage) {
        info.setBook(storage.book);
        info.lecternData.mergeFromServer(storage);
        this.tick(info);
        --info.tickCount;
    }

    @Override
    public boolean isVROnly() {
        return false;
    }
}

