/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfoFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractDragImmersive;
import com.hammy275.immersivemc.client.immersive.info.DragImmersiveInfo;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.UsePacket;
import com.hammy275.immersivemc.common.util.Util;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveLever
extends AbstractDragImmersive {
    private static final AbstractDragImmersive.AutoDragSettings settings = new AbstractDragImmersive.AutoDragSettings(List.of(), false);

    @Override
    protected void hitboxDragged(DragImmersiveInfo info, int controller, int oldIndex, int newIndex) {
        Util.useLever((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
        Network.INSTANCE.sendToServer(new UsePacket(info.getBlockPosition()));
    }

    @Override
    protected AbstractDragImmersive.AutoDragSettings autoDragSettings() {
        return settings;
    }

    @Override
    public void tick(DragImmersiveInfo info) {
        boolean powered = (Boolean)Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition()).m_61143_((Property)BlockStateProperties.f_61448_);
        info.startingHitboxIndex = powered ? 1 : 0;
        super.tick(info);
    }

    @Override
    public DragImmersiveInfo buildInfo(BlockPos pos, Level level) {
        Direction towardsBaseDir;
        DragImmersiveInfo info = new DragImmersiveInfo(pos);
        BlockState state = level.m_8055_(info.getBlockPosition());
        Vec3 center = Vec3.m_82512_((Vec3i)info.getBlockPosition());
        AttachFace attachFace = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction towardsOnDir = switch (attachFace) {
            case AttachFace.WALL -> {
                towardsBaseDir = facing.m_122424_();
                yield Direction.DOWN;
            }
            case AttachFace.CEILING -> {
                towardsBaseDir = Direction.UP;
                yield facing;
            }
            case AttachFace.FLOOR -> {
                towardsBaseDir = Direction.DOWN;
                yield facing;
            }
            default -> throw new IllegalStateException("Lever is attached to unknown face " + attachFace.m_7912_());
        };
        Vec3 towardsBase = Vec3.m_82528_((Vec3i)towardsBaseDir.m_122436_());
        Vec3 towardsOn = Vec3.m_82528_((Vec3i)towardsOnDir.m_122436_());
        center = center.m_82549_(towardsBase.m_82490_(0.25));
        Vec3 offPos = center.m_82549_(towardsOn.m_82490_(-0.25));
        Vec3 onPos = center.m_82549_(towardsOn.m_82490_(0.25));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.m_165882_((Vec3)offPos, (double)0.5, (double)0.5, (double)0.5)));
        info.hitboxes.add(HitboxInfoFactory.instance().interactHitbox((BoundingBox)AABB.m_165882_((Vec3)onPos, (double)0.5, (double)0.5, (double)0.5)));
        return info;
    }

    @Override
    public ImmersiveHandler<NullStorage> getHandler() {
        return ImmersiveHandlers.leverHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("lever", () -> new ItemStack((ItemLike)Items.f_41966_), config -> config.useLeverImmersive, (config, newVal) -> {
            config.useLeverImmersive = newVal;
        });
    }
}

