/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.info;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.client.immersive.book.ClientBookData;
import com.hammy275.immersivemc.client.immersive.book.WrittenBookHelpers;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.compat.apotheosis.ApothStats;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EnchantingData {
    public final ETableData weakData = new ETableData();
    public final ETableData midData = new ETableData();
    public final ETableData strongData = new ETableData();
    public ApothStats apothStats = ApothStats.EMPTY;
    protected ClientBookData bookData = null;

    public boolean hasAnyEnchantments() {
        return this.strongData.isPresent() || this.midData.isPresent() || this.weakData.isPresent();
    }

    @Nullable
    public ClientBookData getBookData(BuiltImmersiveInfo<EnchantingData> info) {
        if (this.bookData == null && Apoth.apothImpl.enchantModuleEnabled()) {
            this.bookData = new ClientBookData();
            this.bookData.renderables.add(new WrittenBookHelpers.BookTextRenderer(leftPage -> {
                if (leftPage.booleanValue()) {
                    boolean hasItem = !info.getItem(0).m_41619_();
                    return FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)"\n"), this.translate("gui.apotheosis.enchant.eterna").m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)"\n"), this.makeStatComponent(this.apothStats.eterna(), 50.0f, hasItem, false).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)"\n\n"), this.translate("gui.apotheosis.enchant.quanta").m_130940_(ChatFormatting.RED), Component.m_237113_((String)"\n"), this.makeStatComponent(this.apothStats.quanta(), 100.0f, hasItem, true).m_130940_(ChatFormatting.RED), Component.m_237113_((String)"\n\n"), this.translate("gui.apotheosis.enchant.arcana").m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)"\n"), this.makeStatComponent(this.apothStats.arcana(), 100.0f, hasItem, true).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)"\n\n"), this.translate("gui.apotheosis.enchant.rectification").m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)"\n"), this.makeStatComponent(this.apothStats.rectification(), 100.0f, hasItem, true).m_130940_(ChatFormatting.YELLOW)});
                }
                return Component.f_130760_;
            }, -0.00375f, new Vec3(0.45, 1.3333333333333333, 0.0)));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.eterna() / 50.0f), new Vec3(1.0, 0.5, 0.0), 0.0f, 197.0f, false, info));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.quanta() / 100.0f), new Vec3(1.0, 0.1, 0.0), 5.0f, 202.0f, false, info));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.arcana() / 100.0f), new Vec3(1.0, -0.3, 0.0), 10.0f, 207.0f, false, info));
            this.bookData.renderables.add(new ApothBarBookRenderable(() -> Float.valueOf(this.apothStats.rectification() / 100.0f), new Vec3(1.0, -0.7, 0.0), 15.0f, 20.0f, true, info));
        } else if (this.bookData != null && !Apoth.apothImpl.enchantModuleEnabled()) {
            this.bookData = null;
        }
        return this.bookData;
    }

    private MutableComponent translate(String key) {
        if (Platform.isModLoaded("zenith")) {
            return Component.m_237115_((String)key.replaceFirst("apotheosis", "zenith"));
        }
        return Component.m_237115_((String)key);
    }

    private MutableComponent makeStatComponent(float stat, float max, boolean hasItem, boolean isPercent) {
        String end;
        String string = end = isPercent ? "%" : "";
        if (!hasItem) {
            return Component.m_237113_((String)"??.??%s/??.??%s".formatted(end, end)).m_130940_(ChatFormatting.OBFUSCATED);
        }
        return Component.m_237113_((String)"%.2f%s/%.2f%s".formatted(Float.valueOf(stat), end, Float.valueOf(max), end));
    }

    public static class ETableData {
        public int levelsNeeded;
        public List<Component> textPreviews = new ArrayList<Component>();

        public boolean isPresent() {
            return this.levelsNeeded > -1;
        }

        public void set(ETableStorage.SlotData data) {
            this.textPreviews.clear();
            if (data.enchantmentHints().isEmpty()) {
                this.textPreviews.add((Component)Component.m_237113_((String)"???"));
            } else {
                for (int i = 0; i < data.enchantmentHints().size(); ++i) {
                    Enchantment ench = Enchantment.m_44697_((int)data.enchantmentHints().get(i));
                    if (ench == null) {
                        this.levelsNeeded = -1;
                        break;
                    }
                    this.levelsNeeded = data.xpLevel();
                    String end = i == data.enchantmentHints().size() - 1 ? "...?" : "";
                    this.textPreviews.add((Component)Component.m_237113_((String)(ench.m_44700_(data.enchantmentHintLevels().get(i).intValue()).getString() + end)));
                }
            }
        }
    }

    private record ApothBarBookRenderable(Supplier<Float> amountFullSupplier, Vec3 offset, float startYEmpty, float startYFull, boolean useOurImageForFull, BuiltImmersiveInfo<EnchantingData> info) implements BookRenderable
    {
        private static ResourceLocation fullLocation = null;
        private static final ResourceLocation emptyLocation = new ResourceLocation("immersivemc", "apoth_bars.png");
        private static final float barMaxX = 109.0f;
        private static final float maxXY = 255.0f;

        @Override
        public void render(PoseStack stack, ClientBookData data, boolean leftPage, int light, PosRot bookPosRot) {
            if (leftPage || this.info.getItem(0).m_41619_()) {
                return;
            }
            if (fullLocation == null) {
                String modId = Platform.isModLoaded("zenith") ? "zenith" : "apotheosis";
                fullLocation = new ResourceLocation(modId, "textures/gui/enchanting_table.png");
            }
            this.renderBar(stack, light, this.amountFullSupplier.get().floatValue());
        }

        private void renderBar(PoseStack stack, int light, float fullAmount) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252961_((float)Math.PI));
            float size = 0.0022935779f;
            stack.m_85841_(size, size, size);
            this.renderBarPart(false, stack, light, 0.0f, this.startYFull, fullAmount);
            this.renderBarPart(true, stack, light, 109.0f * fullAmount, this.startYEmpty, fullAmount);
            stack.m_85849_();
        }

        private void renderBarPart(boolean isEmpty, PoseStack stack, int light, float startX, float startY, float fullAmount) {
            if (!isEmpty && fullAmount <= 0.0f || isEmpty && 1.0f - fullAmount <= 0.0f) {
                return;
            }
            ResourceLocation barLoc = !isEmpty && !this.useOurImageForFull ? fullLocation : emptyLocation;
            VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110458_((ResourceLocation)barLoc));
            PoseStack.Pose lastPose = stack.m_85850_();
            Matrix4f pose = lastPose.m_252922_();
            Matrix3f normal = lastPose.m_252943_();
            float minImageU = startX / 255.0f;
            float maxImageU = (startX + 109.0f * (isEmpty ? 1.0f - fullAmount : fullAmount)) / 255.0f;
            float minImageV = startY / 255.0f;
            float maxImageV = (startY + 4.0f) / 255.0f;
            float minX = isEmpty ? 109.0f * fullAmount : 0.0f;
            float minY = 0.0f;
            float maxX = isEmpty ? 109.0f : 109.0f * fullAmount;
            float maxY = 16.0f;
            consumer.m_252986_(pose, minX, minY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minImageU, maxImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(pose, maxX, minY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxImageU, maxImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(pose, maxX, maxY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxImageU, minImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(pose, minX, maxY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minImageU, minImageV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        }

        @Override
        public Vec3 getStartOffset(ClientBookData data, boolean leftPage, PosRot bookPosRot) {
            return this.offset;
        }
    }
}

