/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive_item;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.client.immersive_item.AbstractHandImmersive;
import com.hammy275.immersivemc.client.immersive_item.info.HeldImageImmersiveInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BiConsumer;
import net.blf02.vrapi.api.data.IVRData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class HeldImageImmersive
extends AbstractHandImmersive<HeldImageImmersiveInfo<?>> {
    private int lastSlot = -1;

    @Override
    protected void render(HeldImageImmersiveInfo<?> info, PoseStack stack, IVRData hand) {
        ImmersiveRenderHelpers.instance().renderImage(stack, info.heldImage, 0.0f, 0.0f, 1.0f, 1.0f, hand.position(), info.size, info.light, null);
    }

    @Override
    protected void tick(HeldImageImmersiveInfo<?> info, IVRData hand, IVRData other) {
        info.light = ImmersiveClientLogicHelpers.instance().getLight(BlockPos.m_274446_((Position)hand.position()));
        this.doTickerTick(info, hand);
    }

    @Override
    public boolean activeForHand(InteractionHand hand) {
        return this.infos.stream().anyMatch(info -> info.hand == hand);
    }

    @Override
    protected HeldImageImmersiveInfo<?> createInfo(InteractionHand hand) {
        throw new RuntimeException("createInfo() doesn't make sense for HeldImageImmersive!");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean onLeftClick(HeldImageImmersiveInfo<?> info, IVRData hand, IVRData other) {
        return false;
    }

    @Override
    public void registerAndTickAll() {
        int currentSlot = Minecraft.m_91087_().f_91074_.m_150109_().f_35977_;
        if (this.lastSlot != currentSlot) {
            this.lastSlot = currentSlot;
            this.infos.clear();
        }
        super.registerAndTickAll();
    }

    public <T> void setHeldImage(InteractionHand hand, ResourceLocation heldImage, ResourceLocation immersiveId, T heldData, float size, BiConsumer<HeldImageImmersiveInfo<T>, IVRData> ticker) {
        this.infos.removeIf(info -> info.hand == hand);
        this.infos.add(new HeldImageImmersiveInfo<T>(hand, heldImage, immersiveId, heldData, size, ticker));
    }

    public List<HeldImageImmersiveInfo<?>> getHeldImages(ResourceLocation immersiveId) {
        return this.infos.stream().filter(info -> info.immersiveId.equals((Object)immersiveId)).toList();
    }

    public void removeImages(ResourceLocation immersiveId) {
        this.infos.removeIf(info -> info.immersiveId.equals((Object)immersiveId));
    }

    private <T> void doTickerTick(HeldImageImmersiveInfo<T> info, IVRData hand) {
        info.ticker.accept(info, hand);
    }
}

