/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ContainerHandler;
import com.hammy275.immersivemc.common.immersive.handler.HandlerUtil;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;

public class BrewingStandHandler
extends ContainerHandler<ListOfItemsStorage> {
    @Override
    public ListOfItemsStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        return HandlerUtil.makeInventoryContentsFromContainer(player, (Container)player.m_9236_().m_7702_(pos), 5);
    }

    @Override
    public ListOfItemsStorage getEmptyNetworkStorage() {
        return new ListOfItemsStorage();
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        Container stand = (Container)player.m_9236_().m_7702_(pos);
        ItemStack standItem = stand.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        if (slot < 3) {
            if (!(stand.m_7013_(slot, playerItem) || playerItem.m_41619_() || standItem.m_41720_() instanceof PotionItem)) {
                return;
            }
            player.m_21008_(hand, standItem);
            stand.m_6836_(slot, playerItem);
        } else {
            if (!stand.m_7013_(slot, playerItem) && !playerItem.m_41619_()) {
                return;
            }
            SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, standItem, amount, (Player)player);
            result.giveToPlayer((Player)player, hand);
            stand.m_6836_(slot, result.immersiveStack());
        }
        stand.m_6596_();
    }

    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return level.m_7702_(pos) instanceof BrewingStandBlockEntity;
    }

    @Override
    public boolean enabledInConfig(Player player) {
        return ActiveConfig.getActiveConfigCommon((Player)player).useBrewingStandImmersive;
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("immersivemc", "brewing_stand");
    }
}

