/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ContainerHandler;
import com.hammy275.immersivemc.common.immersive.handler.HandlerUtil;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;

public class FurnaceHandler
extends ContainerHandler<ListOfItemsStorage> {
    @Override
    public ListOfItemsStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        return HandlerUtil.makeInventoryContentsFromContainer(player, (Container)player.m_9236_().m_7702_(pos), 3);
    }

    @Override
    public ListOfItemsStorage getEmptyNetworkStorage() {
        return new ListOfItemsStorage();
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        WorldlyContainer furnace = (WorldlyContainer)player.m_9236_().m_7702_(pos);
        ItemStack furnaceItem = furnace.m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        if (slot != 2) {
            if (slot != 1 || furnace.m_7013_(1, playerItem) || playerItem.m_41619_()) {
                SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, furnaceItem, amount, (Player)player);
                result.giveToPlayer((Player)player, hand);
                furnace.m_6836_(slot, result.immersiveStack());
            }
        } else {
            SwapResult result = ImmersiveLogicHelpers.instance().swapItemsWithOutput(playerItem, furnaceItem, (Player)player);
            result.giveToPlayer((Player)player, hand);
            furnace.m_6836_(2, result.immersiveStack());
            this.awardXP(furnace, player);
        }
        furnace.m_6596_();
    }

    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return level.m_7702_(pos) instanceof AbstractFurnaceBlockEntity;
    }

    @Override
    public boolean enabledInConfig(Player player) {
        return ActiveConfig.getActiveConfigCommon((Player)player).useFurnaceImmersive;
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("immersivemc", "furnace");
    }

    protected void awardXP(WorldlyContainer furnace, ServerPlayer player) {
        if (furnace instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity afbe = (AbstractFurnaceBlockEntity)furnace;
            afbe.m_155003_(player);
        }
    }
}

