/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.common.compat.TinkersConstruct;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ContainerHandler;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TCCraftingStationHandler
extends ContainerHandler<ListOfItemsStorage> {
    @Override
    public ListOfItemsStorage makeInventoryContents(ServerPlayer player, BlockPos pos) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Container inv = (Container)player.m_9236_().m_7702_(pos);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            items.add(inv.m_8020_(i));
        }
        items.add(Swap.getRecipeOutput(player, items.toArray(new ItemStack[inv.m_6643_()])));
        return new ListOfItemsStorage(items, items.size());
    }

    @Override
    public boolean isDirtyForClientSync(ServerPlayer player, BlockPos pos) {
        return super.isDirtyForClientSync(player, pos) || player.f_19797_ % 2 == 0;
    }

    @Override
    public ListOfItemsStorage getEmptyNetworkStorage() {
        return new ListOfItemsStorage();
    }

    @Override
    public void swap(int slot, InteractionHand hand, BlockPos pos, ServerPlayer player, ItemSwapAmount amount) {
        Container table = (Container)player.m_9236_().m_7702_(pos);
        BlockEntity tableBE = (BlockEntity)table;
        ItemStack playerItem = player.m_21120_(hand).m_41777_();
        if (slot < 9) {
            ItemStack craftingItem = table.m_8020_(slot).m_41777_();
            SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, craftingItem, amount, (Player)player);
            result.giveToPlayer((Player)player, hand);
            table.m_6836_(slot, result.immersiveStack());
        } else {
            int i;
            ItemStack[] items = new ItemStack[10];
            for (i = 0; i <= 8; ++i) {
                items[i] = table.m_8020_(i).m_41777_();
            }
            if ((items = Swap.handleDoCraft(player, items, pos, amount)) == null) {
                return;
            }
            for (i = 0; i <= 8; ++i) {
                table.m_6836_(i, items[i]);
            }
        }
        tableBE.m_6596_();
    }

    @Override
    public boolean isValidBlock(BlockPos pos, Level level) {
        return TinkersConstruct.craftingStation.isInstance(level.m_7702_(pos));
    }

    @Override
    public boolean enabledInConfig(Player player) {
        return ActiveConfig.getActiveConfigCommon((Player)player).useTinkersConstructCraftingStationImmersive;
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("immersivemc", "tinkers_construct_crafting_station");
    }
}

