/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.network.impl;

import com.hammy275.immersivemc.common.compat.apotheosis.ApothStats;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ETableStorage
extends ListOfItemsStorage {
    public SlotData[] slots = new SlotData[]{SlotData.DEFAULT, SlotData.DEFAULT, SlotData.DEFAULT};
    public ApothStats apothStats = ApothStats.EMPTY;

    public ETableStorage(List<ItemStack> items) {
        super(items, 1);
    }

    public ETableStorage() {
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].encode(buffer);
        }
        buffer.writeBoolean(this.apothStats != ApothStats.EMPTY);
        if (this.apothStats != ApothStats.EMPTY) {
            this.apothStats.encode(buffer);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        super.decode(buffer);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = SlotData.decode(buffer);
        }
        if (buffer.readBoolean()) {
            this.apothStats = ApothStats.decode(buffer);
        }
    }

    public record SlotData(int xpLevel, List<Integer> enchantmentHints, List<Integer> enchantmentHintLevels) {
        public static final SlotData DEFAULT = new SlotData(0, List.of(), List.of());

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.xpLevel);
            buffer.writeInt(this.enchantmentHints.size());
            this.enchantmentHints.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
            this.enchantmentHintLevels.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
        }

        public static SlotData decode(FriendlyByteBuf buffer) {
            int xpLevel = buffer.readInt();
            int numHints = buffer.readInt();
            ArrayList<Integer> hints = new ArrayList<Integer>(numHints);
            for (int i = 0; i < numHints; ++i) {
                hints.add(buffer.readInt());
            }
            ArrayList<Integer> hintLevels = new ArrayList<Integer>(numHints);
            for (int i = 0; i < numHints; ++i) {
                hintLevels.add(buffer.readInt());
            }
            return new SlotData(xpLevel, hints, hintLevels);
        }
    }
}

