/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.storage.network.impl;

import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRUtil;
import com.hammy275.immersivemc.mixin.LecternBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LecternData<T extends CommonBookData>
implements NetworkStorage {
    public ItemStack book = ItemStack.f_41583_;
    public T bookData;
    public transient BlockPos pos = BlockPos.f_121853_;
    public transient Level level = null;

    public LecternData(T bookData) {
        this.bookData = bookData;
    }

    public void setBook(ItemStack book, @Nullable LecternBlockEntity lecternServerSide) {
        if (!ItemStack.m_41728_((ItemStack)book, (ItemStack)this.book)) {
            this.book = book;
            ((CommonBookData)this.bookData).resetTurnState();
            ((CommonBookData)this.bookData).setMaxLeftPageIndex(this.findMaxLeftPageIndex());
            if (lecternServerSide != null) {
                ((CommonBookData)this.bookData).setPage(lecternServerSide.m_59568_());
                ((CommonBookData)this.bookData).onSetPageCallback = newPage -> ((LecternBlockEntityAccessor)lecternServerSide).immersiveMC$setPage((int)newPage);
            }
        }
    }

    public void tick(@Nullable Player player) {
        LecternBlockEntity lectern;
        int lecternPageNum;
        if (this.level == null || !ImmersiveHandlers.lecternHandler.isValidBlock(this.pos, this.level)) {
            return;
        }
        if (!this.level.f_46443_ && (lecternPageNum = (lectern = (LecternBlockEntity)this.level.m_7702_(this.pos)).m_59568_()) != ((CommonBookData)this.bookData).getLeftPageIndex() && lecternPageNum != ((CommonBookData)this.bookData).getLeftPageIndex() + 1) {
            ((CommonBookData)this.bookData).setPage(lecternPageNum, false);
        }
        if (player != null) {
            ((CommonBookData)this.bookData).pageTurner = player;
        }
        if (((CommonBookData)this.bookData).pageTurner == null) {
            return;
        }
        if (!VRPluginVerify.playerInVR(((CommonBookData)this.bookData).pageTurner) && ((CommonBookData)this.bookData).getPageChangeState() != PageChangeState.NONE && !((CommonBookData)this.bookData).getPageChangeState().isAnim) {
            ((CommonBookData)this.bookData).startNonVRPageTurnAnim(((CommonBookData)this.bookData).pageTurner, ((CommonBookData)this.bookData).getPageChangeState() == PageChangeState.RIGHT_TO_LEFT);
        }
        PosRot lecternPosRot = this.getLecternPosRot(this.pos);
        if (VRPluginVerify.playerInVR(((CommonBookData)this.bookData).pageTurner)) {
            ((CommonBookData)this.bookData).tick(lecternPosRot, VRUtil.posRot(VRPlugin.API.getVRPlayer(((CommonBookData)this.bookData).pageTurner).getController0()), VRUtil.posRot(VRPlugin.API.getVRPlayer(((CommonBookData)this.bookData).pageTurner).getController1()));
        } else {
            ((CommonBookData)this.bookData).tick(lecternPosRot, new PosRot[0]);
        }
    }

    public PosRot getLecternPosRot(BlockPos pos) {
        Direction lecternDir = (Direction)this.level.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61374_);
        Vec3 lecternPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 1.0, 0.0).m_82549_(Vec3.m_82528_((Vec3i)lecternDir.m_122436_()).m_82490_(0.1));
        return new PosRot(lecternPos, Util.getLookAngle(-0.3926991f, (float)(-Math.toRadians(lecternDir.m_122424_().m_122435_()))), 22.5f, lecternDir.m_122424_().m_122435_(), 0.0f);
    }

    protected int findMaxLeftPageIndex() {
        if (this.book.m_41619_()) {
            return 0;
        }
        return Math.max(WrittenBookItem.m_43477_((ItemStack)this.book) - 1, 0);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.book);
        ((CommonBookData)this.bookData).encode(buffer);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.book = buffer.m_130267_();
        ((CommonBookData)this.bookData).decode(buffer);
    }
}

