/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BeaconDataPacket {
    private static final int speedId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19596_);
    private static final int hasteId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19598_);
    private static final int resistId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19606_);
    private static final int jumpId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19603_);
    private static final int strengthId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19600_);
    private static final int regenId = BuiltInRegistries.f_256974_.m_7447_((Object)MobEffects.f_19605_);
    public final BlockPos pos;
    public final int powerIndex;
    public final boolean useRegen;

    public static BeaconDataPacket fromBeacon(BeaconBlockEntity beacon) {
        BeaconBlockEntityMixin accessor = (BeaconBlockEntityMixin)beacon;
        int primaryId = BuiltInRegistries.f_256974_.m_7447_((Object)accessor.immersiveMC$getPrimaryPower());
        int powerIndex = -1;
        if (primaryId == speedId) {
            powerIndex = 0;
        } else if (primaryId == hasteId) {
            powerIndex = 1;
        } else if (primaryId == resistId) {
            powerIndex = 2;
        } else if (primaryId == jumpId) {
            powerIndex = 3;
        } else if (primaryId == strengthId) {
            powerIndex = 4;
        }
        return new BeaconDataPacket(beacon.m_58899_(), powerIndex, BuiltInRegistries.f_256974_.m_7447_((Object)accessor.immersiveMC$getSecondaryPower()) == regenId);
    }

    public BeaconDataPacket(BlockPos pos, int powerIndex, boolean useRegen) {
        this.pos = pos;
        this.powerIndex = powerIndex;
        this.useRegen = useRegen;
    }

    public BeaconDataPacket(BlockPos pos) {
        this.pos = pos;
        this.powerIndex = -2;
        this.useRegen = false;
    }

    public static void encode(BeaconDataPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).writeInt(packet.powerIndex).writeBoolean(packet.useRegen);
    }

    public static BeaconDataPacket decode(FriendlyByteBuf buffer) {
        return new BeaconDataPacket(buffer.m_130135_(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(BeaconDataPacket packet, ServerPlayer player) {
        if (player == null) {
            NetworkClientHandlers.setBeaconData(packet);
        } else {
            BlockEntity blockEntity = player.m_9236_().m_7702_(packet.pos);
            if (blockEntity instanceof BeaconBlockEntity) {
                BeaconBlockEntity beacon = (BeaconBlockEntity)blockEntity;
                Network.INSTANCE.sendToPlayer(player, BeaconDataPacket.fromBeacon(beacon));
            }
        }
    }
}

