/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;

public class ChestShulkerOpenPacket {
    public BlockPos pos;
    public boolean isOpen;

    public ChestShulkerOpenPacket(BlockPos pos, boolean isOpenPacket) {
        this.pos = pos;
        this.isOpen = isOpenPacket;
    }

    public static void encode(ChestShulkerOpenPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).writeBoolean(packet.isOpen);
    }

    public static ChestShulkerOpenPacket decode(FriendlyByteBuf buffer) {
        return new ChestShulkerOpenPacket(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void handle(ChestShulkerOpenPacket message, ServerPlayer player) {
        if (player != null && NetworkUtil.safeToRun(message.pos, player)) {
            BlockEntity tileEnt = player.m_9236_().m_7702_(message.pos);
            boolean maybeMarkOpen = true;
            if (tileEnt instanceof ChestBlockEntity) {
                if (!ActiveConfig.FILE_SERVER.useChestImmersive) {
                    return;
                }
                ChestBlockEntity chest = (ChestBlockEntity)tileEnt;
                ChestBlockEntity other = Util.getOtherChest(chest);
                if (message.isOpen) {
                    chest.m_5856_((Player)player);
                    ChestToOpenSet.openChest((Player)player, chest.m_58899_());
                    if (other != null) {
                        other.m_5856_((Player)player);
                        ChestToOpenSet.openChest((Player)player, other.m_58899_());
                    }
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                } else {
                    chest.m_5785_((Player)player);
                    ChestToOpenSet.closeChest((Player)player, chest.m_58899_());
                    if (other != null) {
                        other.m_5785_((Player)player);
                        ChestToOpenSet.closeChest((Player)player, other.m_58899_());
                    }
                }
            } else if (tileEnt instanceof EnderChestBlockEntity) {
                if (!ActiveConfig.FILE_SERVER.useChestImmersive) {
                    return;
                }
                EnderChestBlockEntity chest = (EnderChestBlockEntity)tileEnt;
                if (message.isOpen) {
                    chest.m_155515_((Player)player);
                    ChestToOpenSet.openChest((Player)player, chest.m_58899_());
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                } else {
                    chest.m_155522_((Player)player);
                    ChestToOpenSet.closeChest((Player)player, chest.m_58899_());
                }
                maybeMarkOpen = false;
            } else if (tileEnt instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)tileEnt;
                if (!ActiveConfig.FILE_SERVER.useShulkerImmersive) {
                    return;
                }
                if (message.isOpen) {
                    shulkerBox.m_5856_((Player)player);
                } else {
                    shulkerBox.m_5785_((Player)player);
                }
            } else if (tileEnt instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)tileEnt;
                if (!ActiveConfig.FILE_SERVER.useBarrelImmersive) {
                    return;
                }
                if (message.isOpen) {
                    barrel.m_5856_((Player)player);
                    ChestToOpenSet.openChest((Player)player, barrel.m_58899_());
                    PiglinAi.m_34873_((Player)player, (boolean)true);
                } else {
                    barrel.m_5785_((Player)player);
                    ChestToOpenSet.closeChest((Player)player, barrel.m_58899_());
                }
            } else if (!Lootr.lootrImpl.openLootrBarrel(message.pos, (Player)player, message.isOpen) && !Lootr.lootrImpl.openLootrShulkerBox(message.pos, (Player)player, message.isOpen)) {
                maybeMarkOpen = false;
            }
            if (maybeMarkOpen) {
                Lootr.lootrImpl.markOpener((Player)player, message.pos);
            }
        }
    }
}

