/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.forge;

import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.compat.lootr.LootrCompat;
import com.hammy275.immersivemc.common.compat.util.CompatModule;
import com.hammy275.immersivemc.mixin.ChestLidControllerAccessor;
import com.hammy275.immersivemc.server.ChestToOpenSet;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.api.inventory.ILootrInventory;
import noobanidus.mods.lootr.block.entities.LootrBarrelBlockEntity;
import noobanidus.mods.lootr.block.entities.LootrChestBlockEntity;
import noobanidus.mods.lootr.block.entities.LootrShulkerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class LootrCompatImpl
implements LootrCompat {
    private static final Field chestChestLidController;

    private LootrCompatImpl() {
    }

    public static LootrCompat makeCompatImpl() {
        return CompatModule.create(new LootrCompatImpl(), LootrCompat.class, Lootr.compatData);
    }

    @Override
    @Nullable
    public Container getContainer(ServerPlayer player, BlockPos pos) {
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ILootBlockEntity) {
            ILootBlockEntity lootBE = (ILootBlockEntity)blockEntity;
            if (blockEntity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity rcbe = (RandomizableContainerBlockEntity)blockEntity;
                ILootrInventory provider = LootrAPI.getInventory((Level)level, (UUID)lootBE.getTileId(), (BlockPos)pos, (ServerPlayer)player, (RandomizableContainerBlockEntity)rcbe, (arg_0, arg_1, arg_2, arg_3) -> ((ILootBlockEntity)lootBE).unpackLootTable(arg_0, arg_1, arg_2, arg_3), () -> ((ILootBlockEntity)lootBE).getTable(), () -> ((ILootBlockEntity)lootBE).getSeed());
                if (provider instanceof ILootrInventory) {
                    ILootrInventory inventory = provider;
                    return inventory;
                }
            }
        }
        return null;
    }

    @Override
    public void markOpener(Player player, BlockPos pos) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ILootBlockEntity) {
            ILootBlockEntity lootBE = (ILootBlockEntity)blockEntity;
            if (player.m_9236_().f_46443_) {
                lootBE.setOpened(true);
            } else {
                lootBE.getOpeners().add(player.m_20148_());
                blockEntity.m_6596_();
            }
        }
    }

    @Override
    public boolean isLootrContainer(BlockPos pos, Level level) {
        return level.m_8055_(pos).m_204336_(LootrCompat.BLOCK_TAG);
    }

    @Override
    public boolean openLootrBarrel(BlockPos pos, Player player, boolean nowOpen) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof LootrBarrelBlockEntity) {
            LootrBarrelBlockEntity lbbe = (LootrBarrelBlockEntity)blockEntity;
            if (nowOpen) {
                lbbe.m_5856_(player);
                ChestToOpenSet.openChest(player, pos);
            } else {
                lbbe.m_5785_(player);
                ChestToOpenSet.closeChest(player, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean openLootrShulkerBox(BlockPos pos, Player player, boolean nowOpen) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof LootrShulkerBlockEntity) {
            LootrShulkerBlockEntity lsbe = (LootrShulkerBlockEntity)blockEntity;
            if (nowOpen) {
                lsbe.m_5856_(player);
                ChestToOpenSet.openChest(player, pos);
            } else {
                lsbe.m_5785_(player);
                ChestToOpenSet.closeChest(player, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpen(BlockPos pos, Player player) {
        BlockEntity be = player.m_9236_().m_7702_(pos);
        if (be instanceof LootrShulkerBlockEntity) {
            LootrShulkerBlockEntity lsbe = (LootrShulkerBlockEntity)be;
            return !lsbe.isClosed();
        }
        if (be instanceof LootrBarrelBlockEntity) {
            return (Boolean)player.m_9236_().m_8055_(pos).m_61143_((Property)BarrelBlock.f_49043_);
        }
        if (be instanceof LootrChestBlockEntity) {
            try {
                return ((ChestLidControllerAccessor)chestChestLidController.get(be)).immersiveMC$getShouldBeOpen();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        Field chestLidControllerField = null;
        try {
            chestLidControllerField = LootrChestBlockEntity.class.getDeclaredField("chestLidController");
            chestLidControllerField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        chestChestLidController = chestLidControllerField;
    }
}

