/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ChestToOpenSet {
    private static final Map<PosLevel, Set<UUID>> chestImmersiveOpenSet = new HashMap<PosLevel, Set<UUID>>();

    public static void openChest(Player player, BlockPos pos) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(player.m_9236_(), pos, true);
        set.add(player.m_20148_());
    }

    public static void closeChest(Player player, BlockPos pos) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(player.m_9236_(), pos, false);
        if (set != null) {
            set.remove(player.m_20148_());
            if (set.isEmpty()) {
                chestImmersiveOpenSet.remove(new PosLevel(pos, player.m_9236_()));
            }
        }
    }

    public static int getOpenCount(BlockPos pos, Level level) {
        Set<UUID> set = ChestToOpenSet.getOpenSet(level, pos, false);
        return set != null ? set.size() : 0;
    }

    public static void clear() {
        chestImmersiveOpenSet.clear();
    }

    public static void clearForPlayer(Player player) {
        ArrayList toRemove = new ArrayList();
        chestImmersiveOpenSet.forEach((posLevel, set) -> {
            set.remove(player.m_20148_());
            if (set.isEmpty()) {
                toRemove.add(posLevel);
            }
        });
        toRemove.forEach(chestImmersiveOpenSet.keySet()::remove);
    }

    private static Set<UUID> getOpenSet(Level level, BlockPos pos, boolean createIfNotPresent) {
        Set<UUID> set = chestImmersiveOpenSet.get(new PosLevel(pos, level));
        if (createIfNotPresent && set == null) {
            set = new HashSet<UUID>();
            chestImmersiveOpenSet.put(new PosLevel(pos, level), set);
        }
        return set;
    }

    private record PosLevel(BlockPos pos, Level level) {
        public boolean matches(BlockPos otherPos, Level otherLevel) {
            return this.pos.equals((Object)otherPos) && this.level == otherLevel;
        }
    }
}

