/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.mixin.AbstractCauldronBlockAccessor;
import com.hammy275.immersivemc.mixin.BucketItemAccessor;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class CauldronTracker
extends AbstractVRHandTracker {
    private Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();

    @Override
    public void preTick(Player player) {
        super.preTick(player);
        int newCooldown = this.cooldown.getOrDefault(player.m_20148_(), 0) - 1;
        if (newCooldown <= 0) {
            this.cooldown.remove(player.m_20148_());
        } else {
            this.cooldown.put(player.m_20148_(), newCooldown);
        }
    }

    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        if (this.cooldown.getOrDefault(player.m_20148_(), 0) > 0) {
            return false;
        }
        IVRData data = currentVRData.getController(hand.ordinal());
        return player.m_9236_().m_8055_(BlockPos.m_274446_((Position)data.position())).m_60734_() instanceof AbstractCauldronBlock || player.m_9236_().m_8055_(BlockPos.m_274446_((Position)data.position()).m_7495_()).m_60734_() instanceof AbstractCauldronBlock && player.m_9236_().m_8055_(BlockPos.m_274446_((Position)data.position())).m_60795_();
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        BucketItem bucketItem;
        BucketItem bucketItem2;
        IVRData data = currentVRData.getController(hand.ordinal());
        BlockState handState = player.m_9236_().m_8055_(BlockPos.m_274446_((Position)data.position()));
        BlockPos cauldronPos = handState.m_60734_() instanceof AbstractCauldronBlock ? BlockPos.m_274446_((Position)data.position()) : BlockPos.m_274446_((Position)data.position()).m_7495_();
        BlockState cauldron = player.m_9236_().m_8055_(cauldronPos);
        AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)cauldron.m_60734_();
        boolean inCauldronBlock = handState.m_60734_() instanceof AbstractCauldronBlock;
        ItemStack handStack = player.m_21120_(hand);
        Item handItem = handStack.m_41720_();
        Potion heldPotion = PotionUtils.m_43579_((ItemStack)handStack);
        CauldronInteraction interaction = ((AbstractCauldronBlockAccessor)cauldronBlock).immersiveMC$getInteractions().get(handItem);
        if (interaction == null) {
            return;
        }
        if (inCauldronBlock && (handItem instanceof BottleItem || handItem instanceof BucketItem && ((BucketItemAccessor)(bucketItem2 = (BucketItem)handItem)).immersiveMC$getFluid().m_6212_(Fluids.f_76191_))) {
            if (Math.abs(data.getRoll()) < 90.0f) {
                this.possiblySetCooldown(player, interaction.m_175710_(cauldron, player.m_9236_(), cauldronPos, player, hand, handStack));
            }
        } else if (handItem instanceof PotionItem && heldPotion == Potions.f_43599_ || handItem instanceof BucketItem && !((BucketItemAccessor)(bucketItem = (BucketItem)handItem)).immersiveMC$getFluid().m_6212_(Fluids.f_76191_) || handItem instanceof SolidBucketItem) {
            if (Math.abs(data.getRoll()) > 160.0f) {
                this.possiblySetCooldown(player, interaction.m_175710_(cauldron, player.m_9236_(), cauldronPos, player, hand, handStack));
            }
        } else if (inCauldronBlock) {
            this.possiblySetCooldown(player, interaction.m_175710_(cauldron, player.m_9236_(), cauldronPos, player, hand, handStack));
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useCauldronImmersive;
    }

    private void possiblySetCooldown(Player player, InteractionResult res) {
        if (res.m_19077_()) {
            this.cooldown.put(player.m_20148_(), 5);
        }
    }
}

