/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.api_impl.ImmersiveRenderHelpersImpl;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlayerAttachmentImmersive<I extends AbstractPlayerAttachmentInfo, S extends NetworkStorage> {
    public static final int maxLight = class_765.method_23687((int)15, (int)15);
    protected final List<I> infos;
    public final int maxImmersives;
    protected boolean forceDisableItemGuide = false;
    public boolean forceTickEvenIfNoTrack = false;

    public AbstractPlayerAttachmentImmersive(int maxImmersives) {
        Immersives.IMMERSIVE_ATTACHMENTS.add(this);
        this.maxImmersives = maxImmersives;
        this.infos = new ArrayList<I>(maxImmersives > 0 ? maxImmersives + 1 : 16);
    }

    public class_243 playerPos() {
        return ClientUtil.playerPos();
    }

    protected void renderTick(I info, boolean isInVR) {
    }

    public void globalTick() {
    }

    public boolean clientAuthoritative() {
        return false;
    }

    @Nullable
    public abstract ImmersiveHandler<S> getHandler();

    public boolean hitboxesAvailable(AbstractPlayerAttachmentInfo info) {
        return true;
    }

    public abstract boolean shouldRender(I var1, boolean var2);

    protected abstract void render(I var1, class_4587 var2, boolean var3);

    public abstract boolean enabledInConfig();

    protected abstract boolean inputSlotShouldRenderHelpHitbox(I var1, int var2);

    public abstract boolean shouldTrack(class_2338 var1, class_1937 var2);

    @Nullable
    public abstract I refreshOrTrackObject(class_2338 var1, class_1937 var2);

    public abstract boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo var1);

    protected abstract void initInfo(I var1);

    public void onAnyRightClick(AbstractPlayerAttachmentInfo info) {
    }

    public boolean isVROnly() {
        return false;
    }

    public abstract void handleRightClick(AbstractPlayerAttachmentInfo var1, class_1657 var2, int var3, class_1268 var4);

    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, class_1657 player, int hitboxNum) {
    }

    public void onRemove(I info) {
    }

    protected boolean slotHelpBoxIsSelected(I info, int slotNum) {
        return ((AbstractPlayerAttachmentInfo)info).slotHovered(slotNum);
    }

    public abstract void processStorageFromNetwork(AbstractPlayerAttachmentInfo var1, S var2);

    public void tick(I info, boolean isInVR) {
        if (this.enabledInConfig()) {
            if (!((AbstractPlayerAttachmentInfo)info).initCompleted) {
                this.initInfo(info);
                ((AbstractPlayerAttachmentInfo)info).initCompleted = true;
            }
            if (class_310.method_1551().field_1687 != null && (this.shouldTrack(((AbstractPlayerAttachmentInfo)info).getBlockPosition(), (class_1937)class_310.method_1551().field_1687) || this.forceTickEvenIfNoTrack)) {
                this.doTick(info, isInVR);
                ((AbstractPlayerAttachmentInfo)info).setInputSlots();
                ((AbstractPlayerAttachmentInfo)info).light = this.hasMultipleLightPositions(info) ? this.getLight(this.getLightPositions(info)) : this.getLight(this.getLightPos(info));
            } else {
                ((AbstractPlayerAttachmentInfo)info).remove();
            }
        }
    }

    public int getCooldownVR() {
        return 12;
    }

    public int getCooldownDesktop() {
        return 8;
    }

    protected void doTick(I info, boolean isInVR) {
        if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() > 1 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(-1);
        } else if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() < 10 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() <= 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(1);
        }
        if (((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 0) {
            ((AbstractPlayerAttachmentInfo)info).changeTicksLeft(-1);
        }
        ++((AbstractPlayerAttachmentInfo)info).ticksActive;
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5707(class_243.method_24953((class_2382)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) > 256.0) {
            ((AbstractPlayerAttachmentInfo)info).remove();
        }
    }

    public abstract class_2338 getLightPos(I var1);

    public boolean hasMultipleLightPositions(I info) {
        return false;
    }

    public class_2338[] getLightPositions(I info) {
        return new class_2338[0];
    }

    public void doRender(I info, class_4587 stack, boolean isInVR) {
        if (this.shouldRender(info, isInVR)) {
            try {
                this.renderTick(info, isInVR);
                this.render(info, stack, isInVR);
                if (ActiveConfig.active().placementGuideMode != PlacementGuideMode.OFF && !this.forceDisableItemGuide && this.nearbyItemGuideRenderCheck(info)) {
                    for (int i = 0; i < ((AbstractPlayerAttachmentInfo)info).getInputSlots().length; ++i) {
                        if (!this.inputSlotShouldRenderHelpHitbox(info, i)) continue;
                        BoundingBox itemBox = ((AbstractPlayerAttachmentInfo)info).getInputSlots()[i];
                        this.enqueueItemGuideRender(stack, itemBox, 0.2f, this.slotHelpBoxIsSelected(info, i), ((AbstractPlayerAttachmentInfo)info).light);
                    }
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                // empty catch block
            }
        }
    }

    private boolean nearbyItemGuideRenderCheck(I info) {
        class_239 hit = class_310.method_1551().field_1765;
        class_746 player = class_310.method_1551().field_1724;
        boolean inVR = VRPluginVerify.clientInVR();
        class_243 vrHitStart = inVR ? VRPlugin.API.getVRPlayer((class_1657)player).getHMD().position() : null;
        class_243 vrLook = inVR ? VRPlugin.API.getVRPlayer((class_1657)player).getHMD().getLookAngle() : null;
        class_243 vrHitEnd = inVR ? vrHitStart.method_1019(vrLook.method_1021((double)class_310.method_1551().field_1761.method_2904())) : null;
        class_3965 vrHit = inVR ? player.method_37908().method_17742(new class_3959(vrHitStart, vrHitEnd, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player)) : null;
        return hit != null && hit.method_17783() == class_239.class_240.field_1332 && ((class_3965)hit).method_17777().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition()) || this.playerPos().method_1022(class_243.method_24953((class_2382)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) <= 4.0 || vrHit != null && vrHit.method_17783() == class_239.class_240.field_1332 && vrHit.method_17777().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition());
    }

    public List<I> getTrackedObjects() {
        return this.infos;
    }

    public void noInfosTick() {
    }

    public void renderItem(class_1799 item, class_4587 stack, class_243 pos, float size, class_2350 facing, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, pos, size, facing, null, hitbox, renderItemCounts, -1, light);
    }

    public void renderItem(class_1799 item, class_4587 stack, class_243 pos, float size, class_2350 facing, class_2350 upDown, BoundingBox hitbox, boolean renderItemCounts, int spinDegrees, int light) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderItem(item, stack, size, hitbox, renderItemCounts, light, spinDegrees < 0 ? null : Float.valueOf(spinDegrees), facing, upDown);
    }

    protected void enqueueItemGuideRender(class_4587 stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, alpha, isSelected, light));
    }

    protected void renderHitbox(class_4587 stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    protected void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    public static void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    public static void renderHitbox(class_4587 stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, alpha);
    }

    public static class_2350 getLeftOfDirection(class_2350 forward) {
        if (forward == class_2350.field_11036 || forward == class_2350.field_11033) {
            throw new IllegalArgumentException("Direction cannot be up or down!");
        }
        if (forward == class_2350.field_11043) {
            return class_2350.field_11039;
        }
        if (forward == class_2350.field_11039) {
            return class_2350.field_11035;
        }
        if (forward == class_2350.field_11035) {
            return class_2350.field_11034;
        }
        return class_2350.field_11043;
    }

    public static class_243 getTopCenterOfBlock(class_2338 pos) {
        return class_243.method_26410((class_2382)pos, (double)1.0);
    }

    public static class_2350 getForwardFromPlayer(class_1657 player, class_2338 pos) {
        class_2350.class_2351 axis;
        class_243 blockPos = class_243.method_24955((class_2382)pos);
        class_243 playerPos = player.method_19538();
        class_243 diff = playerPos.method_1020(blockPos);
        class_2350.class_2351 class_23512 = axis = Math.abs(diff.field_1352) > Math.abs(diff.field_1350) ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        if (axis == class_2350.class_2351.field_11048) {
            return diff.field_1352 < 0.0 ? class_2350.field_11039 : class_2350.field_11034;
        }
        return diff.field_1350 < 0.0 ? class_2350.field_11043 : class_2350.field_11035;
    }

    public static class_243[] get3x3HorizontalGrid(class_2338 blockPos, double spacing, class_2350 blockForward, boolean use3DCompat) {
        class_243 pos = AbstractPlayerAttachmentImmersive.getTopCenterOfBlock(blockPos);
        if (use3DCompat) {
            pos = pos.method_1031(0.0, 0.0625, 0.0);
        }
        class_2350 left = AbstractPlayerAttachmentImmersive.getLeftOfDirection(blockForward);
        class_243 leftOffset = new class_243((double)left.method_10163().method_10263() * -spacing, 0.0, (double)left.method_10163().method_10260() * -spacing);
        class_243 rightOffset = new class_243((double)left.method_10163().method_10263() * spacing, 0.0, (double)left.method_10163().method_10260() * spacing);
        class_243 topOffset = new class_243((double)blockForward.method_10163().method_10263() * -spacing, 0.0, (double)blockForward.method_10163().method_10260() * -spacing);
        class_243 botOffset = new class_243((double)blockForward.method_10163().method_10263() * spacing, 0.0, (double)blockForward.method_10163().method_10260() * spacing);
        return new class_243[]{pos.method_1019(leftOffset).method_1019(topOffset), pos.method_1019(topOffset), pos.method_1019(rightOffset).method_1019(topOffset), pos.method_1019(leftOffset), pos, pos.method_1019(rightOffset), pos.method_1019(leftOffset).method_1019(botOffset), pos.method_1019(botOffset), pos.method_1019(rightOffset).method_1019(botOffset)};
    }

    public int getLight(class_2338 pos) {
        return ImmersiveClientLogicHelpers.instance().getLight(pos);
    }

    public int getLight(class_2338[] positions) {
        return ImmersiveClientLogicHelpers.instance().getLight(Arrays.stream(positions).toList());
    }

    public void clearImmersives() {
        this.infos.clear();
    }

    public static class_2350 getForwardFromPlayerUpAndDown(class_1657 player, class_2338 pos) {
        return AbstractPlayerAttachmentImmersive.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static class_2350 getForwardFromPlayerUpAndDownFilterBlockFacing(class_1657 player, class_2338 pos, boolean filterOnBlockFacing) {
        class_2350.class_2351 filter = filterOnBlockFacing ? ((class_2350)player.method_37908().method_8320(pos).method_11654((class_2769)class_2318.field_10927)).method_10166() : null;
        class_243 playerPos = player.method_19538();
        if (playerPos.field_1351 >= (double)pos.method_10264() + 0.625 && filter != class_2350.class_2351.field_11052) {
            return class_2350.field_11036;
        }
        if (playerPos.field_1351 <= (double)pos.method_10264() - 0.625 && filter != class_2350.class_2351.field_11052) {
            return class_2350.field_11033;
        }
        class_2350 forward = AbstractPlayerAttachmentImmersive.getForwardFromPlayer(player, pos);
        if (forward.method_10166() != filter) {
            return forward;
        }
        class_2350 blockFacing = (class_2350)player.method_37908().method_8320(pos).method_11654((class_2769)class_2318.field_10927);
        class_243 blockCenter = class_243.method_24953((class_2382)pos);
        class_2350 blockLeftDir = blockFacing.method_10160();
        class_243 blockLeftVec = new class_243((double)blockLeftDir.method_10163().method_10263(), (double)blockLeftDir.method_10163().method_10264(), (double)blockLeftDir.method_10163().method_10260());
        class_243 counterClockwisePos = blockCenter.method_1019(blockLeftVec.method_1021(0.5));
        class_243 clockwisePos = blockCenter.method_1019(blockLeftVec.method_1021(-0.5));
        class_243 upPos = blockCenter.method_1031(0.0, 0.5, 0.0);
        class_243 downPos = blockCenter.method_1031(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.method_1025(playerPos);
        double clockwiseDist = clockwisePos.method_1025(playerPos);
        double upDist = upPos.method_1025(playerPos);
        double downDist = downPos.method_1025(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.method_10160();
        }
        if (min == clockwiseDist) {
            return forward.method_10170();
        }
        if (min == upDist) {
            return class_2350.field_11036;
        }
        return class_2350.field_11033;
    }
}

