/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigConverter;
import com.hammy275.immersivemc.common.config.ConfigType;
import com.hammy275.immersivemc.common.config.ConfigUpgrader;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public class ActiveConfig
implements Cloneable {
    public static final ActiveConfig DISABLED = new ActiveConfig();
    public static final ActiveConfig DEFAULT = new ActiveConfig();
    public static ActiveConfig FILE_SERVER;
    public static ClientActiveConfig FILE_CLIENT;
    public static ActiveConfig FROM_SERVER;
    private static ClientActiveConfig ACTIVE;
    private static final Map<UUID, ClientActiveConfig> CLIENTS;
    public static List<Field> fields;
    public static int fieldsHash;
    protected static final Gson GSON;
    protected static final Gson GSON_NETWORK;
    protected static final Gson GSON_PRETTY;
    public boolean useAnvilImmersive = true;
    public boolean useBrewingStandImmersive = true;
    public boolean useChestImmersive = true;
    public boolean useCraftingTableImmersive = true;
    public boolean useFurnaceImmersive = true;
    public boolean useJukeboxImmersive = true;
    public boolean useRangedGrabImmersive = true;
    public boolean useButtonImmersive = true;
    public boolean useEnchantingTableImmersive = true;
    public boolean useCampfireImmersive = true;
    public boolean useLeverImmersive = true;
    public boolean useBagImmersive = true;
    public boolean useRepeaterImmersive = true;
    public boolean useDoorImmersive = true;
    public boolean useTrapdoorImmersive = true;
    public boolean allowPetting = true;
    public boolean useArmorImmersive = true;
    public boolean useFeedingAnimalsImmersive = true;
    public boolean useShulkerImmersive = true;
    public boolean allowPettingAnythingLiving = false;
    public boolean useShieldImmersive = true;
    public int rangedGrabRange = 8;
    public boolean useBeaconImmersive = true;
    public boolean useBarrelImmersive = true;
    public boolean useThrowingImmersive = true;
    public boolean allowThrowingBeyondVanillaMaxRange = true;
    public boolean useHopperImmersive = true;
    public boolean useSmithingTableImmersive = true;
    public boolean useChiseledBookshelfImmersive = true;
    public boolean useWrittenBookImmersive = true;
    public boolean useCauldronImmersive = true;
    public boolean useIronFurnacesFurnaceImmersive = true;
    public boolean useTinkersConstructCraftingStationImmersive = true;
    public boolean useLecternImmersive = true;
    public boolean useBucketAndBottleImmersive = true;
    public boolean useApotheosisEnchantmentTableImmersive = true;
    public boolean useApotheosisSalvagingTableImmersive = true;
    public boolean useGrindstoneImmersive = true;
    public int commonConfigVersion = 2;
    public static final String COMMON_CONFIG_VERSION = "commonConfigVersion";

    public static ClientActiveConfig getConfigForPlayer(class_1657 player) {
        ClientActiveConfig config = CLIENTS.getOrDefault(player.method_5667(), ClientActiveConfig.DISABLED);
        if (config.disableImmersiveMCOutsideVR && !VRPluginVerify.playerInVR(player) || ImmersiveMCPlayerStorages.isPlayerDisabled(player)) {
            return ClientActiveConfig.DISABLED;
        }
        return config;
    }

    public static ClientActiveConfig active() {
        if (ActiveConfig.FILE_CLIENT.disableImmersiveMCOutsideVR && !VRPluginVerify.clientInVR()) {
            return ClientActiveConfig.DISABLED;
        }
        return ACTIVE;
    }

    public static ClientActiveConfig activeRaw() {
        return ACTIVE;
    }

    public static void registerPlayerConfig(class_1657 player, ClientActiveConfig config) {
        CLIENTS.put(player.method_5667(), config);
    }

    public static ActiveConfig getFileConfig(ConfigType type) {
        return type == ConfigType.CLIENT ? FILE_CLIENT : FILE_SERVER;
    }

    public static ActiveConfig readConfigFile(ConfigType type) {
        ActiveConfig activeConfig;
        boolean didUpgrade;
        Map json;
        BufferedReader reader;
        if (!type.configFile.exists() || !type.configFile.canRead()) {
            return new ClientActiveConfig();
        }
        try {
            reader = new BufferedReader(new FileReader(type.configFile));
            try {
                json = (Map)GSON.fromJson((Reader)reader, Map.class);
                didUpgrade = ConfigUpgrader.upgradeCommonIfNeeded(json);
                if (type == ConfigType.CLIENT) {
                    didUpgrade = ConfigUpgrader.upgradeClientIfNeeded(json) || didUpgrade;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (JsonParseException | IOException | NullPointerException ignored) {
            return type == ConfigType.SERVER ? new ActiveConfig() : new ClientActiveConfig();
        }
        if (didUpgrade) {
            try (FileWriter writer = new FileWriter(type.configFile);){
                writer.write(GSON_PRETTY.toJson((Object)json));
            }
            catch (IOException ignored) {
                return type == ConfigType.SERVER ? new ActiveConfig() : new ClientActiveConfig();
            }
        }
        reader = new BufferedReader(new FileReader(type.configFile));
        try {
            ActiveConfig config = (ActiveConfig)GSON.fromJson((Reader)reader, type.configClass);
            config.validateConfig();
            activeConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException | NullPointerException ignored) {
                return type == ConfigType.SERVER ? new ActiveConfig() : new ClientActiveConfig();
            }
        }
        reader.close();
        return activeConfig;
    }

    public boolean writeConfigFile(ConfigType type) {
        block8: {
            boolean bl;
            boolean createdFile;
            if (!type.configFile.exists() && !(createdFile = type.configFile.createNewFile())) {
                return false;
            }
            if (!type.configFile.canWrite()) break block8;
            FileWriter writer = new FileWriter(type.configFile);
            try {
                writer.write(GSON_PRETTY.toJson((Object)this));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            writer.close();
            return bl;
        }
        return false;
    }

    public static void createDefaultConfigFilesIfNotFound() {
        for (ConfigType type : ConfigType.values()) {
            if (!type.neededOnSide() || type.configFile.exists()) continue;
            type.getDefaultConfig().writeConfigFile(type);
        }
    }

    public static void loadActive() {
        ACTIVE = (ClientActiveConfig)FILE_CLIENT.clone();
        ACTIVE.mergeWithServer(FROM_SERVER);
    }

    public static void loadDisabled() {
        ACTIVE = (ClientActiveConfig)ClientActiveConfig.DISABLED.clone();
    }

    public static ClientActiveConfig getActiveConfigCommon(class_1657 player) {
        return player.method_37908().field_9236 ? ActiveConfig.active() : ActiveConfig.getConfigForPlayer(player);
    }

    public static void remergeAllConfigs() {
        CLIENTS.values().forEach(config -> config.mergeWithServer(FILE_SERVER));
    }

    public void mergeWithServer(ActiveConfig other) {
        this.useAnvilImmersive = this.useAnvilImmersive && other.useAnvilImmersive;
        this.useBrewingStandImmersive = this.useBrewingStandImmersive && other.useBrewingStandImmersive;
        this.useChestImmersive = this.useChestImmersive && other.useChestImmersive;
        this.useCraftingTableImmersive = this.useCraftingTableImmersive && other.useCraftingTableImmersive;
        this.useFurnaceImmersive = this.useFurnaceImmersive && other.useFurnaceImmersive;
        this.useJukeboxImmersive = this.useJukeboxImmersive && other.useJukeboxImmersive;
        this.useRangedGrabImmersive = this.useRangedGrabImmersive && other.useRangedGrabImmersive;
        this.useButtonImmersive = this.useButtonImmersive && other.useButtonImmersive;
        this.useEnchantingTableImmersive = this.useEnchantingTableImmersive && other.useEnchantingTableImmersive;
        this.useCampfireImmersive = this.useCampfireImmersive && other.useCampfireImmersive;
        this.useLeverImmersive = this.useLeverImmersive && other.useLeverImmersive;
        this.useBagImmersive = this.useBagImmersive && other.useBagImmersive;
        this.useRepeaterImmersive = this.useRepeaterImmersive && other.useRepeaterImmersive;
        this.useDoorImmersive = this.useDoorImmersive && other.useDoorImmersive;
        this.useTrapdoorImmersive = this.useTrapdoorImmersive && other.useTrapdoorImmersive;
        this.allowPetting = this.allowPetting && other.allowPetting;
        this.useArmorImmersive = this.useArmorImmersive && other.useArmorImmersive;
        this.useFeedingAnimalsImmersive = this.useFeedingAnimalsImmersive && other.useFeedingAnimalsImmersive;
        this.useShulkerImmersive = this.useShulkerImmersive && other.useShulkerImmersive;
        this.allowPettingAnythingLiving = this.allowPettingAnythingLiving && other.allowPettingAnythingLiving;
        this.useShieldImmersive = this.useShieldImmersive && other.useShieldImmersive;
        this.rangedGrabRange = Math.min(this.rangedGrabRange, other.rangedGrabRange);
        this.useBeaconImmersive = this.useBeaconImmersive && other.useBeaconImmersive;
        this.useBarrelImmersive = this.useBarrelImmersive && other.useBarrelImmersive;
        this.useThrowingImmersive = this.useThrowingImmersive && other.useThrowingImmersive;
        this.allowThrowingBeyondVanillaMaxRange = this.allowThrowingBeyondVanillaMaxRange && other.allowThrowingBeyondVanillaMaxRange;
        this.useHopperImmersive = this.useHopperImmersive && other.useHopperImmersive;
        this.useSmithingTableImmersive = this.useSmithingTableImmersive && other.useSmithingTableImmersive;
        this.useChiseledBookshelfImmersive = this.useChiseledBookshelfImmersive && other.useChiseledBookshelfImmersive;
        this.useWrittenBookImmersive = this.useWrittenBookImmersive && other.useWrittenBookImmersive;
        this.useCauldronImmersive = this.useCauldronImmersive && other.useCauldronImmersive;
        this.useIronFurnacesFurnaceImmersive = this.useIronFurnacesFurnaceImmersive && other.useIronFurnacesFurnaceImmersive;
        this.useTinkersConstructCraftingStationImmersive = this.useTinkersConstructCraftingStationImmersive && other.useTinkersConstructCraftingStationImmersive;
        this.useLecternImmersive = this.useLecternImmersive && other.useLecternImmersive;
        this.useBucketAndBottleImmersive = this.useBucketAndBottleImmersive && other.useBucketAndBottleImmersive;
        this.useApotheosisEnchantmentTableImmersive = this.useApotheosisEnchantmentTableImmersive && other.useApotheosisEnchantmentTableImmersive;
        this.useApotheosisSalvagingTableImmersive = this.useApotheosisSalvagingTableImmersive && other.useApotheosisSalvagingTableImmersive;
        this.useGrindstoneImmersive = this.useGrindstoneImmersive && other.useGrindstoneImmersive;
    }

    public void setDisabled() {
        this.useAnvilImmersive = false;
        this.useBrewingStandImmersive = false;
        this.useChestImmersive = false;
        this.useCraftingTableImmersive = false;
        this.useFurnaceImmersive = false;
        this.useJukeboxImmersive = false;
        this.useRangedGrabImmersive = false;
        this.useButtonImmersive = false;
        this.useEnchantingTableImmersive = false;
        this.useCampfireImmersive = false;
        this.useLeverImmersive = false;
        this.useBagImmersive = false;
        this.useRepeaterImmersive = false;
        this.useDoorImmersive = false;
        this.useTrapdoorImmersive = false;
        this.allowPetting = false;
        this.useArmorImmersive = false;
        this.useFeedingAnimalsImmersive = false;
        this.useShulkerImmersive = false;
        this.allowPettingAnythingLiving = false;
        this.useShieldImmersive = false;
        this.rangedGrabRange = 0;
        this.useBeaconImmersive = false;
        this.useBarrelImmersive = false;
        this.useThrowingImmersive = false;
        this.allowThrowingBeyondVanillaMaxRange = false;
        this.useHopperImmersive = false;
        this.useSmithingTableImmersive = false;
        this.useChiseledBookshelfImmersive = false;
        this.useWrittenBookImmersive = false;
        this.useCauldronImmersive = false;
        this.useIronFurnacesFurnaceImmersive = false;
        this.useTinkersConstructCraftingStationImmersive = false;
        this.useLecternImmersive = false;
        this.useBucketAndBottleImmersive = false;
        this.useApotheosisEnchantmentTableImmersive = false;
        this.useApotheosisSalvagingTableImmersive = false;
        this.useGrindstoneImmersive = false;
    }

    public static void loadFilesToMemory() {
        FILE_SERVER = ActiveConfig.readConfigFile(ConfigType.SERVER);
        if (Platform.isClient()) {
            FILE_CLIENT = (ClientActiveConfig)ActiveConfig.readConfigFile(ConfigType.CLIENT);
        }
        ConfigConverter.maybeDoConversion();
    }

    public void encode(class_2540 buffer) {
        buffer.method_52964(this instanceof ClientActiveConfig);
        buffer.method_53002(fieldsHash);
        buffer.method_10814(GSON_NETWORK.toJson((Object)this));
    }

    public static ActiveConfig decode(class_2540 buffer) {
        Class configClass = buffer.readBoolean() ? ClientActiveConfig.class : ActiveConfig.class;
        int hashFromBuffer = buffer.readInt();
        if (hashFromBuffer != fieldsHash) {
            return (ActiveConfig)DISABLED.clone();
        }
        return (ActiveConfig)GSON_NETWORK.fromJson(buffer.method_19772(), configClass);
    }

    public void validateConfig() {
        this.rangedGrabRange = class_3532.method_15340((int)this.rangedGrabRange, (int)-1, (int)12);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends Enum<T>> T firstEnumIfNull(T val, Class<T> clazz) {
        return (T)(val == null ? ((Enum[])clazz.getEnumConstants())[0] : val);
    }

    protected <T> T defaultIfNull(T val, T def) {
        return val == null ? def : val;
    }

    static {
        CLIENTS = new HashMap<UUID, ClientActiveConfig>();
        fieldsHash = 0;
        GSON = new GsonBuilder().registerTypeAdapter(ItemGuideColorData.class, (Object)new ItemGuideColorData.GsonHandler()).excludeFieldsWithModifiers(new int[]{8}).create();
        GSON_NETWORK = new GsonBuilder().registerTypeAdapter(ItemGuideColorData.class, (Object)new ItemGuideColorData.GsonHandler()).create();
        GSON_PRETTY = new GsonBuilder().registerTypeAdapter(ItemGuideColorData.class, (Object)new ItemGuideColorData.GsonHandler()).excludeFieldsWithModifiers(new int[]{8}).setPrettyPrinting().create();
        DISABLED.setDisabled();
        FROM_SERVER = new ClientActiveConfig();
        FROM_SERVER.setDisabled();
        ActiveConfig.loadFilesToMemory();
        ACTIVE = new ClientActiveConfig();
        Field[] fieldsArr = ActiveConfig.class.getDeclaredFields();
        fields = Arrays.stream(fieldsArr).sorted(Comparator.comparing(Field::getName)).filter(field -> !Modifier.isStatic(field.getModifiers())).toList();
        for (Field f : fields) {
            fieldsHash += f.getName().hashCode();
        }
    }
}

