/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.NetworkClientHandlers;
import com.hammy275.immersivemc.server.immersive.TrackedImmersives;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ConfigSyncPacket {
    public final ActiveConfig config;
    @Nullable
    public final List<class_2960> handlerIDs;

    public ConfigSyncPacket(ActiveConfig config) {
        this(config, null);
    }

    public ConfigSyncPacket(ActiveConfig config, @Nullable List<class_2960> handlerIDs) {
        this.config = config;
        this.handlerIDs = handlerIDs;
    }

    public static void encode(ConfigSyncPacket packet, class_2540 buffer) {
        packet.config.encode(buffer);
        buffer.method_53002(packet.handlerIDs == null ? 0 : packet.handlerIDs.size());
        if (packet.handlerIDs != null) {
            packet.handlerIDs.forEach(arg_0 -> ((class_2540)buffer).method_10812(arg_0));
        }
    }

    public static ConfigSyncPacket decode(class_2540 buffer) {
        ActiveConfig incoming = ActiveConfig.decode(buffer);
        ArrayList<class_2960> handlerIDs = null;
        int numIDs = buffer.readInt();
        if (numIDs > 0) {
            handlerIDs = new ArrayList<class_2960>();
            for (int i = 0; i < numIDs; ++i) {
                handlerIDs.add(buffer.method_10810());
            }
        }
        return new ConfigSyncPacket(incoming, handlerIDs);
    }

    public static void handle(ConfigSyncPacket message, class_3222 player) {
        if (player == null) {
            if (message.handlerIDs != null) {
                NetworkClientHandlers.checkHandlerMatch(message.handlerIDs);
            }
            ActiveConfig.FROM_SERVER = message.config;
            ActiveConfig.loadActive();
            ClientUtil.clearDisabledImmersives();
            Network.INSTANCE.sendToServer(new ConfigSyncPacket(ActiveConfig.FILE_CLIENT));
        } else {
            message.config.mergeWithServer(ActiveConfig.FILE_SERVER);
            ActiveConfig.registerPlayerConfig((class_1657)player, (ClientActiveConfig)message.config);
            TrackedImmersives.clearForPlayer(player);
        }
    }

    public static void syncConfigToPlayer(class_3222 player) {
        Network.INSTANCE.sendToPlayer(player, new ConfigSyncPacket(ImmersiveMCPlayerStorages.isPlayerDisabled((class_1657)player) ? ActiveConfig.DISABLED : ActiveConfig.FILE_SERVER));
    }
}

