/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.api_impl.ItemSwapAmountImpl;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.swap.Swap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SwapPacket {
    public final class_2338 block;
    public final List<Integer> slots;
    public final class_1268 hand;
    public final SwapMode mode;
    public final SwapDestination destination;

    public SwapPacket(class_2338 block, List<Integer> slots, class_1268 hand, SwapMode mode) {
        this(block, slots, hand, mode, SwapDestination.POS);
    }

    public SwapPacket(class_2338 block, List<Integer> slots, class_1268 hand, SwapMode mode, SwapDestination destination) {
        this.block = block;
        this.slots = slots;
        this.hand = hand;
        this.mode = mode;
        this.destination = destination;
    }

    public static void encode(SwapPacket packet, class_2540 buffer) {
        buffer.method_53002(packet.slots.size());
        for (Integer i : packet.slots) {
            buffer.method_53002(i.intValue());
        }
        buffer.method_10807(packet.block);
        buffer.method_53002(packet.hand == class_1268.field_5808 ? 0 : 1);
        buffer.method_10817((Enum)packet.mode);
        buffer.method_10817((Enum)packet.destination);
    }

    public static SwapPacket decode(class_2540 buffer) {
        int size = buffer.readInt();
        ArrayList<Integer> slots = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            slots.add(buffer.readInt());
        }
        SwapPacket ret = new SwapPacket(buffer.method_10811(), slots, buffer.readInt() == 0 ? class_1268.field_5808 : class_1268.field_5810, (SwapMode)buffer.method_10818(SwapMode.class), (SwapDestination)buffer.method_10818(SwapDestination.class));
        return ret;
    }

    public static void handle(SwapPacket message, class_3222 player) {
        int handStackSize = player.method_5998(message.hand).method_7947();
        block0 : switch (message.destination) {
            case POS: {
                if (!NetworkUtil.safeToRun(message.block, player)) break;
                for (ImmersiveHandler<?> handler : ImmersiveHandlers.HANDLERS) {
                    if (!handler.enabledInConfig((class_1657)player) || !Util.isValidBlocks(handler, message.block, player.method_37908())) continue;
                    for (int i = 0; i < message.slots.size(); ++i) {
                        ItemSwapAmountImpl swapAmount = new ItemSwapAmountImpl(message.mode, message.slots.size(), handStackSize, i);
                        handler.swap(message.slots.get(i), message.hand, message.block, player, swapAmount);
                    }
                    break block0;
                }
                break;
            }
            case INVENTORY: {
                if (!ActiveConfig.FILE_SERVER.useBagImmersive) {
                    return;
                }
                if (player == null) break;
                for (int slot : message.slots) {
                    Swap.handleInventorySwap((class_1657)player, slot, class_1268.field_5808);
                }
                break;
            }
            case BAG_CRAFTING: {
                if (player == null) break;
                for (int i = 0; i < message.slots.size(); ++i) {
                    ItemSwapAmountImpl swapAmount = new ItemSwapAmountImpl(message.mode, message.slots.size(), handStackSize, i);
                    Swap.handleBackpackCraftingSwap(message.slots.get(i) - 27, message.hand, ImmersiveMCPlayerStorages.getBackpackCraftingStorage((class_1657)player), player, swapAmount);
                }
                break;
            }
        }
    }

    public static enum SwapDestination {
        POS,
        INVENTORY,
        BAG_CRAFTING;

    }
}

