/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.immersive;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.network.packet.FetchInventoryPacket;
import com.hammy275.immersivemc.common.util.Util;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class TrackedImmersiveData<S extends NetworkStorage> {
    public static final double maxDist = 16.0;
    public final UUID playerUUID;
    private final Set<class_2338> pos;
    private final ImmersiveHandler<S> handler;
    private final class_1937 level;
    private final class_243 center;

    public TrackedImmersiveData(UUID playerUUID, Set<class_2338> pos, ImmersiveHandler<S> handler, class_1937 level) {
        this.playerUUID = playerUUID;
        this.pos = pos;
        this.handler = handler;
        this.level = level;
        this.center = Util.average(pos);
    }

    public boolean shouldSync(class_3222 player) {
        return this.handler.isDirtyForClientSync(player, this.pos.iterator().next());
    }

    public FetchInventoryPacket<S> getSyncPacket(class_3222 player) {
        return new FetchInventoryPacket<S>(this.handler, this.handler.makeInventoryContents(player, this.pos.iterator().next()), this.pos.iterator().next());
    }

    public boolean validForPlayer(class_3222 player) {
        return this.blockMatches() && player.method_5707(this.center) <= 256.0 && this.handler.enabledInConfig((class_1657)player);
    }

    public Set<class_2338> getPos() {
        return this.pos;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public ImmersiveHandler<S> getHandler() {
        return this.handler;
    }

    public boolean blockMatches() {
        return Util.isValidBlocks(this.handler, this.pos, this.level);
    }
}

