/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.handler.WorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ServerUtil;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ImmersiveMCLevelStorage
extends class_18 {
    private static final int LEVEL_STORAGE_VERSION = 2;
    private static class_18.class_8645<ImmersiveMCLevelStorage> factory = new class_18.class_8645(ImmersiveMCLevelStorage::create, ImmersiveMCLevelStorage::load, null);
    private static final String DATA_KEY = "immersivemc_data";
    protected Map<class_2338, WorldStorage> storageMap = new HashMap<class_2338, WorldStorage>();

    private static ImmersiveMCLevelStorage create() {
        return new ImmersiveMCLevelStorage();
    }

    public static ImmersiveMCLevelStorage getLevelStorage(class_3218 level) {
        return (ImmersiveMCLevelStorage)level.method_17983().method_17924(factory, DATA_KEY);
    }

    @Nullable
    public WorldStorage remove(class_2338 pos) {
        return this.storageMap.remove(pos);
    }

    @Nullable
    public WorldStorage get(class_2338 pos, class_1937 level) {
        WorldStorage storage = this.storageMap.get(pos);
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !(handler = (WorldStorageHandler)handlerMaybeWS).getWorldStorageClass().isInstance(storage) || !Util.isValidBlocks(handler, pos, level)) continue;
            return storage;
        }
        return null;
    }

    @Nullable
    public WorldStorage getWithoutVerification(class_2338 pos, class_1937 level) {
        return this.storageMap.get(pos);
    }

    @Nullable
    public WorldStorage getOrCreate(class_2338 pos, class_1937 level) {
        WorldStorage storage = this.get(pos, level);
        if (storage != null) {
            return storage;
        }
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !Util.isValidBlocks(handler = (WorldStorageHandler)handlerMaybeWS, pos, level)) continue;
            storage = handler.getEmptyWorldStorage();
            this.storageMap.put(pos, storage);
            return storage;
        }
        storage = this.storageMap.get(pos);
        if (storage instanceof AnvilStorage) {
            AnvilStorage as = (AnvilStorage)storage;
            if (ImmersiveHandlers.smithingTableHandler.isValidBlock(pos, level)) {
                SmithingTableStorage sts = new SmithingTableStorage();
                sts.copyFromOld(as);
                sts.convertFrom119();
                this.storageMap.put(pos, sts);
                this.method_80();
                return sts;
            }
        }
        return null;
    }

    public static void unmarkAllItemStoragesDirty(MinecraftServer server) {
        for (class_3218 level : server.method_3738()) {
            ImmersiveMCLevelStorage storage = (ImmersiveMCLevelStorage)level.method_17983().method_20786(factory, DATA_KEY);
            if (storage == null) continue;
            storage.storageMap.forEach((pos, ws) -> {
                if (ws instanceof ItemStorage) {
                    ItemStorage is = (ItemStorage)ws;
                    is.setNoLongerDirtyForClientSync();
                }
            });
        }
    }

    public static ImmersiveMCLevelStorage load(class_2487 nbt) {
        ImmersiveMCLevelStorage levelStorage = new ImmersiveMCLevelStorage();
        int lastVanillaDataVersion = nbt.method_10545("lastVanillaDataVersion") ? nbt.method_10550("lastVanillaDataVersion") : Math.min(3700, class_155.method_16673().method_37912().method_38494());
        nbt = ImmersiveMCLevelStorage.maybeUpgradeNBT(nbt, lastVanillaDataVersion);
        Map<class_2338, WorldStorage> storageMap = levelStorage.storageMap;
        storageMap.clear();
        int numOfStorages = nbt.method_10550("numOfStorages");
        class_2487 storages = nbt.method_10562("storages");
        for (int i = 0; i < numOfStorages; ++i) {
            class_2487 storageInfo = storages.method_10562(String.valueOf(i));
            class_2338 pos = new class_2338(storageInfo.method_10550("posX"), storageInfo.method_10550("posY"), storageInfo.method_10550("posZ"));
            class_2960 id = Util.getResourceLocation(storageInfo, "id");
            WorldStorage storage = null;
            for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
                if (!handlerMaybeWS.getID().equals((Object)id) || !(handlerMaybeWS instanceof WorldStorageHandler)) continue;
                WorldStorageHandler handler = (WorldStorageHandler)handlerMaybeWS;
                storage = handler.getEmptyWorldStorage();
                storage.load(storageInfo.method_10562("data"), lastVanillaDataVersion);
                break;
            }
            if (storage == null) continue;
            storageMap.put(pos, storage);
        }
        return levelStorage;
    }

    public class_2487 method_75(class_2487 nbt) {
        nbt.method_10569("lastVanillaDataVersion", class_155.method_16673().method_37912().method_38494());
        nbt.method_10569("version", 2);
        nbt.method_10569("numOfStorages", this.storageMap.size());
        class_2487 storages = new class_2487();
        int i = 0;
        for (Map.Entry<class_2338, WorldStorage> entry : this.storageMap.entrySet()) {
            class_2487 storageInfo = new class_2487();
            storageInfo.method_10569("posX", entry.getKey().method_10263());
            storageInfo.method_10569("posY", entry.getKey().method_10264());
            storageInfo.method_10569("posZ", entry.getKey().method_10260());
            storageInfo.method_10566("data", (class_2520)entry.getValue().save(new class_2487()));
            Util.putResourceLocation(storageInfo, "id", entry.getValue().getHandler().getID());
            storages.method_10566(String.valueOf(i), (class_2520)storageInfo);
            ++i;
        }
        nbt.method_10566("storages", (class_2520)storages);
        return nbt;
    }

    private static class_2487 maybeUpgradeNBT(class_2487 nbtIn, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.method_10545("version")) {
            version = nbtIn.method_10550("version");
        }
        while (version < 2) {
            if (version == 1) {
                int numOfStorages = nbtIn.method_10550("numOfStorages");
                class_2487 storages = nbtIn.method_10562("storages");
                for (int i = 0; i < numOfStorages; ++i) {
                    class_2960 id;
                    class_2487 storage = storages.method_10562(String.valueOf(i));
                    String oldDataType = storage.method_10558("dataType");
                    storage.method_10551("dataType");
                    class_2487 itemsData = storage.method_10562("data");
                    String oldIdentifier = itemsData.method_10558("identifier");
                    itemsData.method_10551("identifier");
                    int numItems = itemsData.method_10550("numOfItems");
                    if (numItems == 10) {
                        id = new class_2960("immersivemc", "crafting_table");
                    } else if (numItems == 4 || numItems == 3 && oldDataType.equals("basic_item_store")) {
                        id = new class_2960("immersivemc", "smithing_table");
                    } else if (numItems == 3) {
                        id = new class_2960("immersivemc", "anvil");
                    } else {
                        if (numItems != 1) continue;
                        class_1799 item = ServerUtil.parseItem(itemsData.method_10562("item0"), lastVanillaDataVersion);
                        id = item.method_31573(class_3489.field_22277) ? new class_2960("immersivemc", "beacon") : new class_2960("immersivemc", "enchanting_table");
                    }
                    Util.putResourceLocation(storage, "id", id);
                }
            }
            ++version;
        }
        return nbtIn;
    }
}

