/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.xmodadditionsxl.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.xmodadditionsxl.procedures.RedstoneSandEntityWalksOnTheBlockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class RedstoneSandBlock
extends FallingBlock {
    public static final MapCodec<RedstoneSandBlock> CODEC = RedstoneSandBlock.simpleCodec(RedstoneSandBlock::new);

    public MapCodec<RedstoneSandBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState blockstate, BlockGetter world, BlockPos pos) {
        return blockstate.getMapColor((BlockGetter)world, (BlockPos)pos).col;
    }

    public RedstoneSandBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SAND).strength(1.0f, 10.0f).lightLevel(s -> 3).instrument(NoteBlockInstrument.SNARE));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        return 7;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        RedstoneSandEntityWalksOnTheBlockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

