/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.xmodadditionsxl.init;

import net.mcreator.xmodadditionsxl.entity.CloudPuffEntity;
import net.mcreator.xmodadditionsxl.entity.EtherealGolemEntity;
import net.mcreator.xmodadditionsxl.entity.EtherealStrayEntity;
import net.mcreator.xmodadditionsxl.entity.MinigunProjectileEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class XmodAdditionsXlModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"xmod_additions_xl");
    public static final DeferredHolder<EntityType<?>, EntityType<EtherealStrayEntity>> ETHEREAL_STRAY = XmodAdditionsXlModEntities.register("ethereal_stray", EntityType.Builder.of(EtherealStrayEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<EtherealGolemEntity>> ETHEREAL_GOLEM = XmodAdditionsXlModEntities.register("ethereal_golem", EntityType.Builder.of(EtherealGolemEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<CloudPuffEntity>> CLOUD_PUFF = XmodAdditionsXlModEntities.register("cloud_puff", EntityType.Builder.of(CloudPuffEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<MinigunProjectileEntity>> MINIGUN_PROJECTILE = XmodAdditionsXlModEntities.register("minigun_projectile", EntityType.Builder.of(MinigunProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"xmod_additions_xl", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        EtherealStrayEntity.init(event);
        EtherealGolemEntity.init(event);
        CloudPuffEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ETHEREAL_STRAY.get(), EtherealStrayEntity.createAttributes().build());
        event.put((EntityType)ETHEREAL_GOLEM.get(), EtherealGolemEntity.createAttributes().build());
        event.put((EntityType)CLOUD_PUFF.get(), CloudPuffEntity.createAttributes().build());
    }
}

