/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.operation;

import javax.annotation.Nonnull;
import org.mtr.core.data.Route;
import org.mtr.core.operation.CarDetails;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class ArrivalResponseSchema
implements SerializedDataBase {
    protected final String destination;
    protected final long arrival;
    protected final long departure;
    protected final long deviation;
    protected final boolean realtime;
    protected final long departureIndex;
    protected final boolean isTerminating;
    protected final long routeId;
    protected final String routeName;
    protected final String routeNumber;
    protected final long routeColor;
    protected final Route.CircularState circularState;
    protected final long platformId;
    protected final String platformName;
    protected final ObjectArrayList<CarDetails> cars = new ObjectArrayList();

    protected ArrivalResponseSchema(String destination, long arrival, long departure, long deviation, boolean realtime, long departureIndex, boolean isTerminating, long routeId, String routeName, String routeNumber, long routeColor, Route.CircularState circularState, long platformId, String platformName) {
        this.destination = destination;
        this.arrival = arrival;
        this.departure = departure;
        this.deviation = deviation;
        this.realtime = realtime;
        this.departureIndex = departureIndex;
        this.isTerminating = isTerminating;
        this.routeId = routeId;
        this.routeName = routeName;
        this.routeNumber = routeNumber;
        this.routeColor = routeColor;
        this.circularState = circularState;
        this.platformId = platformId;
        this.platformName = platformName;
    }

    protected ArrivalResponseSchema(ReaderBase readerBase) {
        this.destination = readerBase.getString("destination", "");
        this.arrival = readerBase.getLong("arrival", 0L);
        this.departure = readerBase.getLong("departure", 0L);
        this.deviation = readerBase.getLong("deviation", 0L);
        this.realtime = readerBase.getBoolean("realtime", false);
        this.departureIndex = readerBase.getLong("departureIndex", 0L);
        this.isTerminating = readerBase.getBoolean("isTerminating", false);
        this.routeId = readerBase.getLong("routeId", 0L);
        this.routeName = readerBase.getString("routeName", "");
        this.routeNumber = readerBase.getString("routeNumber", "");
        this.routeColor = readerBase.getLong("routeColor", 0L);
        this.circularState = EnumHelper.valueOf(Route.CircularState.values()[0], readerBase.getString("circularState", ""));
        this.platformId = readerBase.getLong("platformId", 0L);
        this.platformName = readerBase.getString("platformName", "");
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("cars", this.cars::clear, readerBaseChild -> this.cars.add(new CarDetails((ReaderBase)readerBaseChild)));
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("destination", this.destination);
        writerBase.writeLong("arrival", this.arrival);
        writerBase.writeLong("departure", this.departure);
        writerBase.writeLong("deviation", this.deviation);
        writerBase.writeBoolean("realtime", this.realtime);
        writerBase.writeLong("departureIndex", this.departureIndex);
        writerBase.writeBoolean("isTerminating", this.isTerminating);
        writerBase.writeLong("routeId", this.routeId);
        writerBase.writeString("routeName", this.routeName);
        writerBase.writeString("routeNumber", this.routeNumber);
        writerBase.writeLong("routeColor", this.routeColor);
        writerBase.writeString("circularState", this.circularState.toString());
        writerBase.writeLong("platformId", this.platformId);
        writerBase.writeString("platformName", this.platformName);
        this.serializeCars(writerBase);
    }

    @Nonnull
    public String toString() {
        return "destination: " + this.destination + "\narrival: " + this.arrival + "\ndeparture: " + this.departure + "\ndeviation: " + this.deviation + "\nrealtime: " + this.realtime + "\ndepartureIndex: " + this.departureIndex + "\nisTerminating: " + this.isTerminating + "\nrouteId: " + this.routeId + "\nrouteName: " + this.routeName + "\nrouteNumber: " + this.routeNumber + "\nrouteColor: " + this.routeColor + "\ncircularState: " + (Object)((Object)this.circularState) + "\nplatformId: " + this.platformId + "\nplatformName: " + this.platformName + "\ncars: " + this.cars + "\n";
    }

    protected void serializeCars(WriterBase writerBase) {
        writerBase.writeDataset(this.cars, "cars");
    }
}

