/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GuiDrawing
extends DummyClass {
    private BufferBuilder bufferBuilder;
    private Matrix4f matrix;
    private final GraphicsHolder graphicsHolder;

    @MappedMethod
    public GuiDrawing(GraphicsHolder graphicsHolder) {
        this.graphicsHolder = graphicsHolder;
    }

    @MappedMethod
    public void beginDrawingRectangle() {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.m_85850_().m_85861_();
        this.bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, int color) {
        if (this.matrix != null && this.bufferBuilder != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.bufferBuilder.m_85982_(this.matrix, (float)x1, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x1, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x2, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x2, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
            });
        }
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int color) {
        if (this.matrix != null && this.bufferBuilder != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.bufferBuilder.m_85982_(this.matrix, (float)x1, (float)y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x2, (float)y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x3, (float)y3, 0.0f).m_6122_(r, g, b, a).m_5752_();
                this.bufferBuilder.m_85982_(this.matrix, (float)x4, (float)y4, 0.0f).m_6122_(r, g, b, a).m_5752_();
            });
        }
    }

    @MappedMethod
    public void finishDrawingRectangle() {
        if (this.bufferBuilder != null) {
            this.bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)this.bufferBuilder);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }
    }

    @MappedMethod
    public void beginDrawingTexture(Identifier identifier) {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.m_85850_().m_85861_();
        this.bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)identifier.data));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
    }

    @MappedMethod
    public void drawTexture(double x1, double y1, double x2, double y2, float u1, float v1, float u2, float v2) {
        if (this.matrix != null && this.bufferBuilder != null) {
            this.bufferBuilder.m_85982_(this.matrix, (float)x1, (float)y1, 0.0f).m_7421_(u1, v1).m_5752_();
            this.bufferBuilder.m_85982_(this.matrix, (float)x1, (float)y2, 0.0f).m_7421_(u1, v2).m_5752_();
            this.bufferBuilder.m_85982_(this.matrix, (float)x2, (float)y2, 0.0f).m_7421_(u2, v2).m_5752_();
            this.bufferBuilder.m_85982_(this.matrix, (float)x2, (float)y1, 0.0f).m_7421_(u2, v1).m_5752_();
        }
    }

    @MappedMethod
    public void finishDrawingTexture() {
        if (this.bufferBuilder != null) {
            this.bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)this.bufferBuilder);
        }
    }
}

