/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.mapper.GraphicsHolder;

public final class MainEventBusClient {
    Runnable startClientTickRunnable = () -> {};
    Runnable endClientTickRunnable = () -> {};
    Runnable clientJoinRunnable = () -> {};
    Runnable clientDisconnectRunnable = () -> {};
    Consumer<ClientWorld> startWorldTickRunnable = world -> {};
    Consumer<ClientWorld> endWorldTickRunnable = world -> {};
    BiConsumer<ClientWorld, WorldChunk> chunkLoadConsumer = (world, chunk) -> {};
    BiConsumer<ClientWorld, WorldChunk> chunkUnloadConsumer = (world, chunk) -> {};
    Consumer<GraphicsHolder> guiRenderingConsumers = graphicsHolder -> {};

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                this.startClientTickRunnable.run();
                break;
            }
            case END: {
                this.endClientTickRunnable.run();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.world instanceof ClientLevel) {
            switch (event.phase) {
                case START: {
                    this.startWorldTickRunnable.accept(new ClientWorld((ClientLevel)event.world));
                    break;
                }
                case END: {
                    this.endWorldTickRunnable.accept(new ClientWorld((ClientLevel)event.world));
                }
            }
        }
    }

    @SubscribeEvent
    public void clientJoin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        this.clientJoinRunnable.run();
    }

    @SubscribeEvent
    public void clientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.clientDisconnectRunnable.run();
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ClientLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkLoadConsumer.accept(new ClientWorld((ClientLevel)event.getWorld()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ClientLevel && event.getChunk() instanceof LevelChunk) {
            this.chunkUnloadConsumer.accept(new ClientWorld((ClientLevel)event.getWorld()), new WorldChunk((LevelChunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void guiRendering(RenderGameOverlayEvent.Post event) {
        GraphicsHolder.createInstanceSafe(event.getMatrixStack(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), this.guiRenderingConsumers);
    }
}

