/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockItemExtension;
import org.mtr.mapping.mapper.EntityExtension;

public final class ModEventBus {
    final List<Supplier<Block>> BLOCKS = new ArrayList<Supplier<Block>>();
    final List<Supplier<BlockItemExtension>> BLOCK_ITEMS = new ArrayList<Supplier<BlockItemExtension>>();
    final List<Supplier<Item>> ITEMS = new ArrayList<Supplier<Item>>();
    final List<Supplier<BlockEntityType<? extends BlockEntityExtension>>> blockEntityTypes = new ArrayList<Supplier<BlockEntityType<? extends BlockEntityExtension>>>();
    final List<Supplier<EntityType<? extends EntityExtension>>> entityTypes = new ArrayList<Supplier<EntityType<? extends EntityExtension>>>();
    final List<Supplier<ParticleType<?>>> particleTypes = new ArrayList();
    final List<Supplier<SoundEvent>> soundEvents = new ArrayList<Supplier<SoundEvent>>();

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        this.BLOCKS.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((Block)supplier.get())));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        this.BLOCK_ITEMS.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((Item)supplier.get())));
        this.ITEMS.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((Item)supplier.get())));
    }

    @SubscribeEvent
    public void registerBlockEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
        this.blockEntityTypes.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)supplier.get())));
    }

    @SubscribeEvent
    public void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        this.entityTypes.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((EntityType)supplier.get())));
    }

    @SubscribeEvent
    public void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        this.particleTypes.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((ParticleType)supplier.get())));
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        this.soundEvents.forEach(supplier -> event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)supplier.get())));
    }
}

