/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mod.Blocks;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;

public abstract class BlockTrainSensorBase
extends BlockExtension
implements BlockWithEntity {
    public BlockTrainSensorBase() {
        super(Blocks.createDefaultBlockSettings(true));
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && entity.data instanceof BlockEntityBase) {
                ((BlockEntityBase)((Object)((Object)entity.data))).markDirty2();
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast(player), new PacketOpenBlockEntityScreen(pos));
            }
        });
    }

    public static boolean matchesFilter(World world, BlockPos pos, long routeId, double speed) {
        BlockEntity entity = world.getBlockEntity(pos);
        return entity != null && entity.data instanceof BlockEntityBase && ((BlockEntityBase)((Object)entity.data)).matchesFilter(routeId, speed);
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        private boolean stoppedOnly;
        private boolean movingOnly;
        private final LongAVLTreeSet filterRouteIds = new LongAVLTreeSet();
        private static final String KEY_ROUTE_IDS = "route_ids";
        private static final String KEY_STOPPED_ONLY = "stopped_only";
        private static final String KEY_MOVING_ONLY = "moving_only";

        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long[] routeIdsArray;
            for (long routeId : routeIdsArray = compoundTag.getLongArray(KEY_ROUTE_IDS)) {
                this.filterRouteIds.add(routeId);
            }
            this.stoppedOnly = compoundTag.getBoolean(KEY_STOPPED_ONLY);
            this.movingOnly = compoundTag.getBoolean(KEY_MOVING_ONLY);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLongArray(KEY_ROUTE_IDS, new ArrayList<Long>(this.filterRouteIds));
            compoundTag.putBoolean(KEY_STOPPED_ONLY, this.stoppedOnly);
            compoundTag.putBoolean(KEY_MOVING_ONLY, this.movingOnly);
        }

        public boolean matchesFilter(long routeId, double speed) {
            if (!this.filterRouteIds.isEmpty() && !this.filterRouteIds.contains(routeId)) {
                return false;
            }
            return speed < 0.0 || !this.stoppedOnly && !this.movingOnly || this.stoppedOnly && speed == 0.0 || this.movingOnly && speed > 0.0;
        }

        public LongAVLTreeSet getRouteIds() {
            return this.filterRouteIds;
        }

        public boolean getStoppedOnly() {
            return this.stoppedOnly;
        }

        public boolean getMovingOnly() {
            return this.movingOnly;
        }

        public void setData(LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
            this.filterRouteIds.clear();
            this.filterRouteIds.addAll(filterRouteIds);
            this.stoppedOnly = stoppedOnly;
            this.movingOnly = movingOnly;
            this.markDirty2();
        }
    }
}

